package gov.va.med.ccht.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.model.ldap.LdapPerson;

@Entity
@Table(schema = "HT", name = "APP_USER")
public class SimpleUser extends UserPrincipalImpl {

	private static final long serialVersionUID = 8175242732620450379L;
	
	private Long id;
	private SimpleVisn visn;
	private SimpleFacility facility;
	private SimpleFacility secondaryFacility;
	private Vendor vendor;
	private Date inactiveDate;

	public SimpleUser() {
		super();
	}

	public SimpleUser(String name) {
		super(name);
	}

	public SimpleUser(LdapPerson person) {
		setLdapPerson(person);
	}

	@Id
	@Column(name="APP_USER_ID", nullable=false, updatable=false)
	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String toString() {
		return getUsername();
	}

	@ManyToOne
	@JoinColumn(name = "VISN_ID")
	public SimpleVisn getVisn() {
		return visn;
	}

	public void setVisn(SimpleVisn visn) {
		this.visn = visn;
	}

	@ManyToOne
	@JoinColumn(name = "PRI_FACILITIES_ID")
	public SimpleFacility getFacility() {
		return facility;
	}

	public void setFacility(SimpleFacility facility) {
		this.facility = facility;
	}

	@ManyToOne
	@JoinColumn(name="SEC_FACILITIES_ID")
	public SimpleFacility getSecondaryFacility() {
		return secondaryFacility;
	}

	public void setSecondaryFacility(SimpleFacility secondaryFacility) {
		this.secondaryFacility = secondaryFacility;
	}

	@ManyToOne
	@JoinColumn(name="VENDOR_ID")
	public Vendor getVendor() {
		return vendor;
	}

	public void setVendor(Vendor vendor) {
		this.vendor = vendor;
	}

	@Column(name="INACTIVE_DATE")
	public Date getInactiveDate() {
		return inactiveDate;
	}

	public void setInactiveDate(Date inactiveDate) {
		this.inactiveDate = inactiveDate;
	}
}