package gov.va.med.ccht.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

import org.apache.commons.lang3.StringUtils;

@MappedSuperclass
public class CCHTAuditFields {

	private String recordCreatedBy;
	private Date recordCreatedDate;
	private String recordModifiedBy;
	private Date recordModifiedDate;
	private short recordModifiedCount;

	@Column(name = "RECORD_CREATED_BY", length = 30, nullable = false)
	public String getRecordCreatedBy() {
		return recordCreatedBy;
	}

	public void setRecordCreatedBy(String recordCreatedBy) {
		if (StringUtils.isEmpty(recordCreatedBy)) {
			this.recordCreatedBy = "";
		} else {
			this.recordCreatedBy = recordCreatedBy;
		}
	}

	@Column(name = "RECORD_CREATED_DATE", nullable = false)
	public Date getRecordCreatedDate() {
		return recordCreatedDate;
	}

	public void setRecordCreatedDate(Date recordCreatedDate) {
		this.recordCreatedDate = recordCreatedDate;
	}

	@Column(name = "RECORD_MODIFIED_BY", length = 30, nullable = false)
	public String getRecordModifiedBy() {
		return recordModifiedBy;
	}

	public void setRecordModifiedBy(String recordModifiedBy) {
		this.recordModifiedBy = recordModifiedBy;
	}

	@Column(name = "RECORD_MODIFIED_DATE", nullable = false)

	public Date getRecordModifiedDate() {
		return recordModifiedDate;
	}

	public void setRecordModifiedDate(Date recordModifiedDate) {
		this.recordModifiedDate = recordModifiedDate;
	}

	@Column(name = "RECORD_MODIFIED_COUNT", nullable = false)
	public short getRecordModifiedCount() {
		return recordModifiedCount;
	}

	public void setRecordModifiedCount(short recordModifiedCount) {
		this.recordModifiedCount = recordModifiedCount;
	}

}
