package gov.va.med.ccht.jobs;

import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.ccht.persistent.JobDAO;
import gov.va.med.ccht.service.report.StandardReportService;
import gov.va.med.fw.model.batchprocess.JobResult;
import gov.va.med.fw.model.batchprocess.JobStatus;

@Component
public class PurgeCompletedJobsJob extends CchtJob implements Job {

	private Logger logger = Logger.getLogger(getClass());

	@Override
	public void execute(final JobExecutionContext context) throws JobExecutionException {

		JobDAO jobDao = (JobDAO) context.getJobDetail().getJobDataMap().get("jobDao");
		StandardReportService reportService = (StandardReportService) context.getJobDetail().getJobDataMap().get("reportService");
		String name = (String) context.getJobDetail().getKey().getName();
		String group = (String) context.getJobDetail().getKey().getGroup();

		logger.info("Purging completed jobs from the database.");

		JobResult result = saveJobStartingInDatabase(jobDao, group, name, name);

		try {

			reportService.purgeCompletedReports();

			saveJobCompletedInDatabase(jobDao, result, JobStatus.COMPLETE);

		} catch (final Exception e) {

			logger.warn("Issue performing PurgeCompletedJobsJob.");
			e.printStackTrace();

			saveJobCompletedInDatabase(jobDao, result, JobStatus.COMPLETE_WITH_ERROR);

		}

		logger.info("Finished purging completed jobs from the database.");

	}

}
