package gov.va.med.ccht.controller;

import static gov.va.med.ccht.model.qir.QIRStatusType.AGREED;
import static gov.va.med.ccht.model.qir.QIRStatusType.APPROVED;
import static gov.va.med.ccht.model.qir.QIRStatusType.NEW;
import static gov.va.med.ccht.model.qir.QIRStatusType.REPLIED;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

import gov.va.med.ccht.model.CCHTPermissions;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.model.qir.QIRSearchParameters;
import gov.va.med.ccht.model.qir.QIRSearchResult;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.ui.model.TermType;

@Controller
public class ViewMyQIRSController extends CchtController {

	public static final String SESSION_ATTR_LAST_QIR_SEARCH_RESULT_ID_SET = "lastQIRSearchResultIDs";

	@RequestMapping(value = "/viewMyQirs.html", method = RequestMethod.GET)
	public String showViewMyQirs(Model model, HttpSession session) throws Exception {
		QIRSearchParameters qirSearchParameters = new QIRSearchParameters();
		UserPrincipal currentUser = getCurrentUser();
		User user = (User) getCurrentUser();
		String userId = currentUser.getUserCredentials().getUserID();

		if (currentUser.isPermissionGranted(CCHTPermissions.APPROVE_QIR)) {
			// national admin
			qirSearchParameters.setQirStatuses(Arrays.asList(NEW, APPROVED, REPLIED, AGREED));
		} else if (currentUser.isPermissionGranted(CCHTPermissions.REPLY_QIR)) {
			// vendor
			Vendor vendor = user.getVendor();
			if (vendor != null) {
				qirSearchParameters.setVendor(new TermType(vendor.getName(), vendor.getCode()));
				qirSearchParameters.setQirStatuses(Arrays.asList(APPROVED, REPLIED, AGREED));
			}
		} else if (currentUser.isPermissionGranted(CCHTPermissions.VISN_ADMIN)) {
			SimpleVisn visn = user.getVisn();
			if (visn != null) {
				TermType theVisn = new TermType();
				theVisn.setLabel(visn.getDescription());
				theVisn.setValue(visn.getName());
				qirSearchParameters.setVisn(theVisn);
			}
			qirSearchParameters.setSubmittedBy(userId);
			qirSearchParameters.setQirStatuses(Arrays.asList(NEW, APPROVED, REPLIED, AGREED));
		} else if (currentUser.isPermissionGranted(CCHTPermissions.FACILITY_ADMIN)) {
			SimpleFacility facility = user.getFacility();
			if (facility != null) {
				TermType theFacility = new TermType();
				theFacility.setLabel(facility.getName());
				theFacility.setValue(facility.getCode());
				qirSearchParameters.setFacility(theFacility);
			}
			qirSearchParameters.setSubmittedBy(userId);
			qirSearchParameters.setQirStatuses(Arrays.asList(NEW, APPROVED, REPLIED, AGREED));
		} else {
			qirSearchParameters.setQirStatuses(Arrays.asList(NEW, APPROVED, REPLIED, AGREED));
			qirSearchParameters.setSubmittedBy(userId);
		}
		qirSearchParameters.setMaxRecords(100);
		
		List<QIRSearchResult> results = qirService.searchQIR(qirSearchParameters);
		
		Set<Long> uniqueIds = new HashSet<>();
		
		results.forEach(result -> {
			uniqueIds.add(new Long(result.getId()));
		});

		session.setAttribute(SESSION_ATTR_LAST_QIR_SEARCH_RESULT_ID_SET, uniqueIds);

		model.addAttribute("qirList", results);

		return "viewMyQirs";
	}

}
