package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import gov.va.med.ccht.model.CCHTRoles;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.model.common.Device;
import gov.va.med.ccht.model.common.DeviceType;
import gov.va.med.ccht.model.common.ReportWeek;
import gov.va.med.ccht.model.common.SimpleFacility;
import gov.va.med.ccht.model.common.SimpleVisn;
import gov.va.med.ccht.model.common.Vendor;
import gov.va.med.ccht.service.common.TerminologyCache;
import gov.va.med.ccht.service.common.TerminologyException;
import gov.va.med.ccht.service.common.device.DeviceService;
import gov.va.med.ccht.service.common.reports.ReportService;
import gov.va.med.ccht.ui.common.TermTypeWrapper;
import gov.va.med.fw.model.ldap.SearchCriteria;
import gov.va.med.fw.model.lookup.AbstractActiveLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.model.TermType;

@Controller
public class TerminologyController extends CchtController implements CCHTRoles {

	@Autowired
	protected TerminologyCache terminologyCache;
	
	@Autowired
	protected DeviceService deviceService;
	
	@Autowired
	protected ReportService reportService;
	
	/*
	 * 
	 * EVERYTHING THAT FOLLOWS IS POST MIGRATION FROM FLEX TO Spring MVC DO NOT
	 * USE ANYTHING THAT FOLLOWS.
	 * 
	 */
	@Deprecated
	public TermTypeWrapper getWrappedTermType(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<? extends Lookup> terms = terminologyCache.getTerms(termTypeName);
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertToTermType(terms) : terms);
	}

	@Deprecated
	public List<? extends Lookup> getTermType(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		return terminologyCache.getTerms(termTypeName);
	}

	/**
	 * Get User assigned VISNs
	 * 
	 * @param termTypeName
	 * @param varName
	 * @param convert
	 * @param uid
	 * @return
	 * @throws Exception
	 */
	@Deprecated
	public TermTypeWrapper getVisns(String termTypeName, String varName, boolean convert, String uid) throws Exception {
		List<SimpleVisn> terms = getUserVisns();
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertVisnsToTermType(terms, false) : terms);
	}

	@Deprecated
	public TermTypeWrapper getReportVisns(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<SimpleVisn> terms = getUserVisns();
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertVisnsToTermType(terms, true) : terms);
	}

	@Deprecated
	private List<SimpleVisn> getUserVisns() throws ServiceException {
		User currentUser = (User) getCurrentUser();
		List<SimpleVisn> terms = new ArrayList<SimpleVisn>();
		if (currentUser.isPermissionGranted(NATIONAL_ADMIN) || currentUser.isPermissionGranted(APPLICATION_ADMIN)
				|| currentUser.isPermissionGranted(MANAGEMENT)) {
			terms = visnService.getSimpleVisns();
		} else if (currentUser.isPermissionGranted(VISN_ADMIN)) {
			if (currentUser.getVisn() != null) {
				terms.add(currentUser.getVisn());
			}
		} else {
			// none
		}
		return terms;
	}

	@Deprecated
	public SortedSet<SimpleFacility> getUserFacilities() throws ServiceException {
		User currentUser = (User) getCurrentUser();
		SortedSet<SimpleFacility> terms = new TreeSet<SimpleFacility>();
		if (currentUser.isPermissionGranted(NATIONAL_ADMIN) || currentUser.isPermissionGranted(APPLICATION_ADMIN)
				|| currentUser.isPermissionGranted(MANAGEMENT)) {
			terms = facilityService.getSimpleFacilities();

		} else if (currentUser.isPermissionGranted(VISN_ADMIN) || currentUser.isPermissionGranted(QIR_ORIGINATOR)) {
			if (currentUser.getVisn() != null) {
				terms = facilityService.getSimpleFacilities(currentUser.getVisn());
			}
		} else {
			if (currentUser.getFacility() != null) {
				terms.add(currentUser.getFacility());
			}
			if (currentUser.getSecondaryFacility() != null) {
				terms.add(currentUser.getSecondaryFacility());
			}
		}
		return terms;
	}

	@Deprecated
	public TermTypeWrapper getDevices(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<Device> terms = deviceService.getDevices();
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertDevicesToTermType(terms) : terms);
	}

	@Deprecated
	public TermTypeWrapper getDeviceTypes(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<? extends Lookup> terms = terminologyCache.getTerms(termTypeName);
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertDeviceTypesToTermType(terms) : terms);
	}

	@Deprecated
	public TermTypeWrapper getVendorByDevice(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<? extends Lookup> terms = terminologyCache.getTerms(termTypeName);
		return new TermTypeWrapper(termTypeName, varName, uid,
				convert ? convertVendorDeviceTypesToTermType(terms) : terms);
	}

	@Deprecated
	public TermTypeWrapper getReportWeeks(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<ReportWeek> terms = reportService.getReportWeeks();
		return new TermTypeWrapper(termTypeName, varName, uid, terms);
	}

	@Deprecated
	public TermTypeWrapper getVendors(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		List<Vendor> terms = vendorService.getActiveVendors();
		return new TermTypeWrapper(termTypeName, varName, uid, convert ? convertVendorsToTermType(terms) : terms);
	}

	@Deprecated
	public TermTypeWrapper getCareCoordinators(String termTypeName, String varName, boolean convert, String uid)
			throws Exception {
		User currentUser = (User) getCurrentUser();
		if (currentUser.getFacility() != null) {
			SearchCriteria searchCriteria = new SearchCriteria();
			// Add role
			List<String> roles = new ArrayList<String>();
			roles.add(CCHTRoles.CARE_COORDINATOR);
			searchCriteria.setRoles(roles);
			// Add sites

			List<SimpleFacility> facilities = new ArrayList<SimpleFacility>(); // getUserFacilities();

			facilities.add(currentUser.getFacility());

			List<String> sites = new ArrayList<String>();
			for (SimpleFacility facility : facilities) {
				sites.add(facility.getStationNumber());
			}
			searchCriteria.setStations(sites);

			List<User> users = securityService.findAppUsers(searchCriteria);
			return new TermTypeWrapper(termTypeName, varName, uid, convertUserToTermType(users));
		} else {
			// empty list for all other users
			return new TermTypeWrapper(termTypeName, varName, uid, convertUserToTermType(new ArrayList<User>()));
		}
	}

	@Deprecated
	public List<TermType> getFacilityCareCoordinators(TermType facility) throws Exception {
		SearchCriteria searchCriteria = new SearchCriteria();
		// Add role
		List<String> roles = new ArrayList<String>();
		roles.add(CCHTRoles.CARE_COORDINATOR);
		searchCriteria.setRoles(roles);
		List<String> sites = new ArrayList<String>();
		sites.add(facility.getValue());
		searchCriteria.setStations(sites);

		List<User> users = securityService.findAppUsers(searchCriteria);
		List<TermType> result = new ArrayList<TermType>();
		for (User o : users) {
			result.add(new TermType(o.getFullName(), o.getUsername()));
		}
		return result;
	}

//	@Deprecated
//	public TermTypeWrapper getFacilitators(String termTypeName, String varName, boolean convert, String uid)
//			throws Exception {
//		List<DMPToolUser> terms = dmpService.findDmpFacilitators();
//		return new TermTypeWrapper(termTypeName, varName, uid,
//				convert ? convertFacilitatorsToTermType(terms, false) : terms);
//	}
//
//	@Deprecated
//	public TermTypeWrapper getAssignees(String termTypeName, String varName, boolean convert, String uid)
//			throws Exception {
//		List<DMPToolUser> terms = dmpService.findAllDMPToolUsers();
//		return new TermTypeWrapper(termTypeName, varName, uid,
//				convert ? convertAssigneesToTermType(terms, false) : terms);
//	}

	@Deprecated
	private List<TermType> convertToTermType(List<? extends Lookup> list) {
		List<TermType> result = new ArrayList<TermType>();
		for (Lookup o : list) {
			if (o instanceof AbstractActiveLookup) {
				AbstractActiveLookup lookup = (AbstractActiveLookup) o;
				result.add(new TermType(o.getName(), o.getCode(), lookup.isActive()));
			} else {
				result.add(new TermType(o.getName(), o.getCode()));
			}
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertVisnsToTermType(List<SimpleVisn> list, Boolean addAllVisns) {
		List<TermType> result = new ArrayList<TermType>();
		// Add all VIsns
		if (list.size() > 1 && addAllVisns) {
			SimpleVisn allVisns = SimpleVisn.ALL_VISNS;
			result.add(new TermType(allVisns.getName(), allVisns.getName()));
		}
		for (SimpleVisn o : list) {
			result.add(new TermType(o.getName(), o.getCode()));
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertFacilitiesToTermType(SortedSet<SimpleFacility> list, Boolean addAllFacilities) {
		List<TermType> result = new ArrayList<TermType>();
		// Add All Facilities
		if (list.size() > 1 && addAllFacilities) {
			SimpleFacility allFacilities = SimpleFacility.ALL_FACILITIES;
			result.add(new TermType(allFacilities.getName(), allFacilities.getName()));
		}
		for (SimpleFacility o : list) {
			result.add(new TermType(o.getDescription(), o.getCode()));
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertDevicesToTermType(List<Device> list) {
		List<TermType> result = new ArrayList<TermType>();
		// Add Null Device
		Device nullDevice = Device.NULL_DEVICE;
		result.add(new TermType(nullDevice.getDeviceName(), nullDevice.getDeviceName()));
		for (Device o : list) {
			result.add(new TermType(o.getDeviceName(), o.getDeviceName()));
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertVendorsToTermType(List<Vendor> list) {
		List<TermType> result = new ArrayList<TermType>();
		// Add Null Device
		for (Vendor o : list) {
			result.add(new TermType(o.getName(), String.valueOf(o.getId())));
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertDeviceTypesToTermType(List<? extends Lookup> list) {
		List<TermType> result = new ArrayList<TermType>();
		// Add Null Device Type
		result.add(new TermType(DeviceType.NULL_DEVICE_NAME, DeviceType.NULL_DEVICE_NAME));
		for (Lookup o : list) {
			result.add(new TermType(o.getName(), o.getCode()));
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertVendorDeviceTypesToTermType(List<? extends Lookup> list) {
		List<TermType> result = new ArrayList<TermType>();
		// Add Null Device Type
		result.add(new TermType(DeviceType.NULL_DEVICE_NAME, DeviceType.NULL_DEVICE_NAME));
		for (Lookup o : list) {
			if (o instanceof DeviceType) {
				result.add(
						new TermType(((DeviceType) o).getCode(), String.valueOf(((DeviceType) o).getVendor().getId())));
			}
		}
		return result;
	}

	@Deprecated
	private List<TermType> convertUserToTermType(List<User> list) {
		List<TermType> result = new ArrayList<TermType>();
		for (User o : list) {
			result.add(new TermType(o.getFullName(), o.getUsername()));
		}
		return result;
	}

//	@Deprecated
//	private List<TermType> convertFacilitatorsToTermType(List<DMPToolUser> list, Boolean addDMPFacilitators) {
//		List<TermType> result = new ArrayList<TermType>();
//		// Add Null Device
//		for (DMPToolUser o : list) {
//			result.add(new TermType(o.getAppUser().getFullName(), String.valueOf(o.getAppUser().getUsername())));
//		}
//		return result;
//	}
//
//	@Deprecated
//	private List<TermType> convertAssigneesToTermType(List<DMPToolUser> list, Boolean addDMPFacilitators) {
//		List<TermType> result = new ArrayList<TermType>();
//		// Add Null Device
//		for (DMPToolUser o : list) {
//			result.add(new TermType(o.getAppUser().getFullName(), String.valueOf(o.getAppUser().getId())));
//		}
//		return result;
//	}

}
