package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;

import gov.va.med.ccht.model.CCHTRoles;
import gov.va.med.ccht.model.User;
import gov.va.med.ccht.ui.model.UserForm;
import gov.va.med.fw.security.SecurityContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.ui.model.TermType;

@Controller
public class MyPreferenceController extends CchtController {

	@RequestMapping(value = "/CCHT.html")
	public String closePage(Model model) throws Exception {
		return "CCHT";
	}

	@RequestMapping(value = "/myPreferences.html")
	public String showMyPreferences(Model model, HttpSession session) throws Exception {

		UserPrincipal currentUser = getCurrentUser();
		User user = securityService.getUser(currentUser.getUserCredentials().getUserID());
		UserForm userForm = new UserForm();
		securityConversionService.convert(user, userForm);
		List<TermType> assignedRoles = userForm.getRoles();
		List<TermType> availableRoles = new ArrayList<TermType>(); // getAllRoles();
		List<TermType> allRoles = new ArrayList<TermType>(); // getAllRoles();
		List<SimpleRole> roles;
		if (currentUser.isPermissionGranted(CCHTRoles.NATIONAL_ADMIN)) {
			roles = securityService.getAllSimpleRoles();
		} else {
			roles = securityService.getAllSimpleRoles();
		}
		for (SimpleRole role : roles) {
			allRoles.add(new TermType(role.getName(), role.getName()));
		}
		// filter the available roles based on the user role
		if (currentUser.isPermissionGranted(CCHTRoles.NATIONAL_ADMIN)) {
			// no filtering
			availableRoles = allRoles;
		} else {

			User loginUser = (User) currentUser;
			boolean canAddRole = false;
			if (currentUser.isPermissionGranted(CCHTRoles.FACILITY_ADMIN)) {

				if (loginUser.getFacility() != null) {
					if (user.getFacility() != null && (loginUser.getFacility().getId() == user.getFacility()
							.getId())) {
						canAddRole = true;
					} else if (user.getSecondaryFacility() != null && (loginUser.getFacility().getId() == user.getSecondaryFacility().getId())) {
						canAddRole = true;
					}
				} else if (loginUser.getSecondaryFacility() != null) {
					if (user.getFacility() != null && (loginUser.getSecondaryFacility().getId() == user
							.getFacility().getId())) {
						canAddRole = true;
					} else if (user.getSecondaryFacility() != null && (loginUser.getSecondaryFacility().getId() == user.getSecondaryFacility().getId())) {
						canAddRole = true;
					}
				}
				if (canAddRole) {
					availableRoles.add(SecurityController.FACILITY_ADMIN_ROLE);
					availableRoles.add(SecurityController.CARE_COORDINATOR_ROLE);
					availableRoles.add(SecurityController.PROGRAM_ASSISTANT_ROLE);
					availableRoles.add(SecurityController.APPLICATION_ADMIN_ROLE);
				}
			}
			canAddRole = false;
			if (currentUser.isPermissionGranted(CCHTRoles.VISN_ADMIN)) {
				// keep Facility Administrator, Care Coordinator, QIR
				// Originator, Program Support Assistant, Application
				// Administrator
				// if user and current user are in the same VISN, otherwise,
				// remove all
				if (loginUser.getVisn() != null && user.getVisn() != null
						&& (loginUser.getVisn().getId() == user.getVisn().getId())) {
					canAddRole = true;
				}
				if (canAddRole) {
					if (!availableRoles.contains(SecurityController.VISN_ADMIN_ROLE))
						availableRoles.add(SecurityController.VISN_ADMIN_ROLE);
					if (!availableRoles.contains(SecurityController.FACILITY_ADMIN_ROLE))
						availableRoles.add(SecurityController.FACILITY_ADMIN_ROLE);
					if (!availableRoles.contains(SecurityController.CARE_COORDINATOR_ROLE))
						availableRoles.add(SecurityController.CARE_COORDINATOR_ROLE);
					if (!availableRoles.contains(SecurityController.QIR_ORIGINATOR_ROLE))
						availableRoles.add(SecurityController.QIR_ORIGINATOR_ROLE);
					if (!availableRoles.contains(SecurityController.PROGRAM_ASSISTANT_ROLE))
						availableRoles.add(SecurityController.PROGRAM_ASSISTANT_ROLE);
				}
			}
		}

		availableRoles.removeAll(assignedRoles);
		userForm.setAvailableRoles(availableRoles);

		model.addAttribute("userId", userForm.getUserName());
		model.addAttribute("assignedRoles", userForm.getRolesAsString());
		model.addAttribute("company", userForm.getVendorName());
		return "myPreferences";
	}

}
