package gov.va.med.ccht.controller;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import edu.emory.mathcs.backport.java.util.Arrays;
import gov.va.med.ccht.ui.model.RoleForm;
import gov.va.med.fw.model.EntityKeyFactory;
import gov.va.med.fw.security.Permission;
import gov.va.med.fw.security.Role;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.SimpleRole;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;

@Controller
public class ManageRolesController extends CchtController {
    
    //add @InitBinder to fix Fortify issue
    @InitBinder
    public void initBinder(WebDataBinder binder)
    {   
        String[] allowedFields = {"id", "name", "description", "selectedPermissions"};
        binder.setAllowedFields(allowedFields);        
    }
    
    @RequestMapping("/roles")
    public @ResponseBody Map<String, Object> roleList() throws Exception {
        Map<String, Object> results = new HashMap<>();
        List<SimpleRole> simpleRoles = securityService.getAllSimpleRoles();
        results.put("roles", simpleRoles);
        return results;
    }

    @RequestMapping(value = "/roleSelect.html")
    public String roleSelect() throws Exception {
        return "roleSelect";
    }
    
    @RequestMapping(value = "/roleAdd.html", method = RequestMethod.GET)
    public String roleNew(ModelMap model, @RequestParam(required = false) Long roleId) throws Exception {

        final List<String> roleNames = new ArrayList<String>();
        securityService.getAllRoles().forEach(r -> roleNames.add(r.getName().toLowerCase()));
        
        Role role = new Role();
        if (roleId != null) {
            role = securityService.getRoleById(roleId); 
            roleNames. remove(role.getName().toLowerCase());
        }

        RoleForm form = new RoleForm(role);

        model.put("command", form);
        model.put("existingRoleNames", roleNames);

        populatePermissionsCheckboxGroup(model, form); 

        return "roleAdd";
    }

    @RequestMapping(value = "/roleEdit.html", method = RequestMethod.GET)
    public String roleEdit(ModelMap model, @RequestParam(required = false) Long roleId) throws Exception {

        final List<String> roleNames = new ArrayList<String>();
        securityService.getAllRoles().forEach(r -> roleNames.add(r.getName().toLowerCase()));
        
        Role role = new Role();
        if (roleId != null) {
            role = securityService.getRoleById(roleId); 
            roleNames. remove(role.getName().toLowerCase());
        }

        RoleForm form = new RoleForm(role);

        model.put("command", form);
        model.put("existingRoleNames", roleNames);

        populatePermissionsCheckboxGroup(model, form); 

        return "roleEdit";
    }

    private void populateReferenceData(ModelMap model) throws ServiceException {
        Map<Long, String> allPermissions = new LinkedHashMap<>();
        for (Permission p : securityService.getAllPermissions()) {
            allPermissions.put(p.getId(), p.getName());
        }
        model.put("allRolesMap", allPermissions);
    }
    
    private void populatePermissionsCheckboxGroup(ModelMap model, RoleForm form) throws ServiceException {
        
        List<Permission> allPermissions = securityService.getAllPermissions();
        List<String> selectedPermissions = new ArrayList<String>(Arrays.asList(form.getSelectedPermissions()));
        
        Map<Permission, Boolean> permissions = new LinkedHashMap<Permission, Boolean>();
        
        for(Permission p : allPermissions) {
            if(selectedPermissions.contains(p.getName())) {
                permissions.put(p, true); // is checked

            }
            else {
                permissions.put(p, false); // not checked
            }
        }
        
        model.put("permissionCheckBoxes", permissions);
            
    }

    @RequestMapping(value = "/roleEdit.html", method = RequestMethod.POST)
    public String submitRoleNewOrEdit(@ModelAttribute("command") RoleForm command,  ModelMap model,
            HttpServletRequest request) throws Exception {
        RoleForm roleForm = command;
        Role role = securityService.getRole(roleForm.getName());
        
        // existing role
        if (StringUtils.isNotEmpty(roleForm.getId()) && !roleForm.getId().equals("null")) {
            Long roleId = Long.parseLong(roleForm.getId());
            role = securityService.getRole(EntityKeyFactory.createEntityKey(roleId, Role.class));
        }
        // new role
        boolean newRole = false;
        
        if (role == null) {
            role = new Role();
            newRole = true;
        }
        
        String username = SecurityContextHelper.getCurrentUser().getUsername();
        
        // update
        Date currentDate = Calendar.getInstance().getTime();
        role.setName(roleForm.getName());
        role.setDescription(roleForm.getDescription());
        role.setRecordModifiedDate(currentDate);
        role.setRecordModifiedBy(username);
        if(newRole) {
            // keep RecordModifiedCount at 0 for new role
            role.setRecordCreatedBy(username);
            role.setRecordCreatedDate(currentDate);
        }
        else {
            role.setRecordModifiedCount((short) (role.getRecordModifiedCount() + 1));
        }

        Set<Permission> permissions = new HashSet<>();
        List<Permission> allPermissions = securityService.getAllPermissions();
        List<String> selectedPermissions = new ArrayList<String>(Arrays.asList(command.getSelectedPermissions()));
        
        for (Permission p : allPermissions) {            
            if (selectedPermissions.contains(p.getName()))
                permissions.add(p);
        }
        role.setPermissions(permissions, username);
        
        if(newRole){
            securityService.updateRole(role);
            userNotifier.notifyUserOnceWithMessage(request, "The role was added successfully.");
        }
        else {
            securityService.updateRole(role);
            userNotifier.notifyUserOnceWithMessage(request, "The role was updated successfully.");
        }
        
        return "redirect:" + basePath + "roleSelect.html";
    }

}
