package gov.va.med.ccht.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.springframework.stereotype.Controller;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import gov.va.med.ccht.model.CCHTPermissions;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;

@Controller
public class LoginController {
	
	public static boolean isAuthorizedAny(String[] permissions) {

		UserPrincipal up = SecurityContextHelper.getCurrentUser();

		for (String permission : permissions) {
			if (up.isPermissionGranted(permission)) {
				return true;
			}
		}

		return false;
	}
	
	public static HttpSession getCurrentHttpSession() {
		RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
		if (requestAttributes instanceof ServletRequestAttributes) {
			HttpServletRequest r = ((ServletRequestAttributes) requestAttributes).getRequest();
			return r.getSession();
		}

		return null;
	}
	
	public static void setMenuVisibilityByPermissions() {
		
		getCurrentHttpSession().setAttribute("showMyProfile", true);
		getCurrentHttpSession().setAttribute("showWelcomeBar", true);
		getCurrentHttpSession().setAttribute("showAdministration", false);
		getCurrentHttpSession().setAttribute("showQIR", false);
		getCurrentHttpSession().setAttribute("showHtReports", false);

		UserPrincipal currentUser = SecurityContextHelper.getCurrentUser();

		boolean canManageRegistrations = currentUser.isPermissionGranted(CCHTPermissions.MANAGE_REGISTRATIONS);
		boolean canManageUsers = currentUser.isPermissionGranted(CCHTPermissions.MANAGE_USERS);
		boolean applicationAdmin = currentUser.isPermissionGranted(CCHTPermissions.APPLICATION_ADMIN);
		boolean canManageRoles = currentUser.isPermissionGranted(CCHTPermissions.MANAGE_ROLES);
		boolean canManageBatchJobs = currentUser.isPermissionGranted(CCHTPermissions.MANAGE_BATCH_JOBS);

		if (canManageRegistrations || canManageUsers || applicationAdmin || canManageRoles || canManageBatchJobs) {
			getCurrentHttpSession().setAttribute("showAdministration", true);
			getCurrentHttpSession().setAttribute("showManageRegistration", canManageRegistrations);
			getCurrentHttpSession().setAttribute("showManageUser", canManageUsers);
			getCurrentHttpSession().setAttribute("showManageRoles", canManageRoles);
			getCurrentHttpSession().setAttribute("showManageScheduledJobs", canManageBatchJobs);
		}

		if (currentUser.isPermissionGranted(CCHTPermissions.CREATE_QIR)
				|| isAuthorizedAny(CCHTPermissions.QIR_UPDATE_PERMISSIONS)
				|| currentUser.isPermissionGranted(CCHTPermissions.READ_QIR)) {
			getCurrentHttpSession().setAttribute("showQIR", true);

			if (currentUser.isPermissionGranted(CCHTPermissions.CREATE_QIR)) {
				getCurrentHttpSession().setAttribute("canCreateQIR", true);
			} else {
				getCurrentHttpSession().setAttribute("canCreateQIR", false);
			}
		}

		if (!currentUser.isPermissionGranted(CCHTPermissions.VENDOR) && 
				!currentUser.isPermissionGranted(CCHTPermissions.APPLICATION_ADMIN)) {
			getCurrentHttpSession().setAttribute("showHtReports", true);
		}
	}
	
	public static void hideWelcomeBar() {
		getCurrentHttpSession().setAttribute("showWelcomeBar", false);
	}

}
