<%@ include file="inc_header.jsp"%>

<script type="text/javascript">
	$(
			function() {
				var theTable = $('#userTable').DataTable({
					"dom" : '<"top">rt<"bottom"><"clear">',
					autowidth : true,
					searching : false,
					select : 'single',
					"language" : {
						"emptyTable" : "No users were found."
					}
				})

				$("#selectUserButton")
						.click(
								function() {
									var theUser = $('#userTable').data(
											'selectedUsername')
									if (theUser)
										document.location.href = 'ShowManageUsersEdit.html?userName='
												+ theUser
												+ "&fromPage=userSearch"
								})

				$('#userTable tbody').on(
						'click',
						'tr',
						function() {
							var theRow = $(this)
							var isSelected = theRow.hasClass('selected')
							var theTable = $('#userTable')
							theTable.removeData('selectedUsername')
							if (isSelected)
								theTable.data('selectedUsername', theRow
										.attr('username'))
							$('#selectUserButton').toggle(isSelected)
						})
			})
			
	function forceFocusOnTableHeader() {
		$(this).parent().focus()	
	}
</script>

<table id="userTable" border="1" summary="List of Users">
	<thead>
		<tr>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort User ID">User ID</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Name">Name</a>Name</th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Title">Title</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Department">Department</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Office">Office</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Phone Number">Phone Number</a></th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${users}" var="user">
			<tr username="<c:out value="${user.username}" />">
				<td><c:out value="${user.username}" /></td>
				<td><c:out value="${user.fullName}" /></td>
				<td><c:out value="${user.title}" /></td>
				<td><c:out value="${user.department}" /></td>
				<td><c:out value="${user.office}" /></td>
				<td><c:out value="${user.telephoneNumber}" /></td>
			</tr>
		</c:forEach>
	</tbody>
</table>

<div style="margin-top: 10px">
	<input type="button" class="button" title="Select" id="selectUserButton"
		value="Select" style="display: none" /> <input type="button"
		class="button" title="Cancel" id="cancelButton" value="Cancel"
		onclick="document.location.href='manageUsersSearch.html'" />
</div>