<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/roleEdit.css">

<script type="text/javascript" src="js/roleEdit.js"></script>
<%@ include file="inc_errors.jsp" %>

<form:form id="roleForm" action="roleEdit.html" method="post" onsubmit="return validateForm()">
	<div id="roleEditContainer">
		<table>
			<tr>
				<td class="alignRight"><label for="roleName">Role Name:</label><span class="invisibleRequiredFor508">*</span></td>
				<td><h2 class="required">*</h2></td>
				<td><form:input id="roleName" path="name" size="20" alt="required field"/></td>
			</tr>
			<tr>
				<td class="alignRight"><label for="description">Description:</label><span class="invisibleRequiredFor508">*</span></td>
				<td><h2 class="required">*</h2></td>
				<td><form:textarea id="description" path="description" alt="required field" rows="4" cols="70"  aria-required="true"/></td>
			</tr>			
			<tr>
			<td>Permissions:</td>
			<td>&nbsp;</td>
			<td>
				<div id="permissionsContainer">
					<c:forEach var="roleName" items="${existingRoleNames}">
						<div style="display: none;" data-role-name="${roleName}"></div>
					</c:forEach>
					<c:forEach var="permission" items="${permissionCheckBoxes}">
						<span>				
							<c:choose>
								<c:when test="${permission.value}"> 
									<form:checkbox name="selectedPermissions" checked="checked" path="selectedPermissions" value="${permission.key}" id="${permission.key.id}"/>
								</c:when>
								<c:otherwise>
									<form:checkbox name="selectedPermissions" path="selectedPermissions" value="${permission.key}" id="${permission.key.id}"/>
								</c:otherwise>
							</c:choose>
							<label for="${permission.key.id}">${permission.key}</label>
						</span>
					</c:forEach>
				</div>
			</td>
			</tr>
		
		</table>
		<input type="submit" class="submitAnchor" value="Submit" />
		<button type="button" onclick="javascript:resetForm()">Reset</button>
		<button type="button" onclick="javascript:cancelRoleUpdate()">Cancel</button>		
	</div>
</form:form>