<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
		var nationalTotalsResultsTable = $('#responseRateNationalResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			columnDefs: [
				{ targets: 0, "width": "200px"},
				{ targets: '_all', "width": "150px" }
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
	})
</script>

<div id="responseRateNationalResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="responseRateNationalResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Vendor">Vendor</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Responders">Responders</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Partial Responders">Partial Responders</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Non-Responders">Non-Responders</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Unknown">Unknown</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="TOTAL">TOTAL</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Non-response for more than 30 days">Non-response for more than 30 days</a></th>
			<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Greatest days of non-response">Greatest days of non-response</a></th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${responseRateRows}" var="row">
			<tr>
				<c:choose>
					<%-- There's not really a better way to do this, but the last two rows
					are special cases so you need to match them to this first column value. --%>
					<c:when test="${row.vendorName == 'TOTALS BY RESPONSE RATE'}">
						<td>${row.columnZero}</td>
						<td><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td>${row.columnFive}</td>
						<td></td>
						<td></td>
					</c:when>
					<c:when test="${row.vendorName == 'PERCENT OF TOTAL'}">
						<td>${row.columnZero}</td>
						<td>${row.columnOne}</td>
						<td>${row.columnTwo}</td>
						<td>${row.columnThree}</td>
						<td>${row.columnFour}</td>
						<td><fmt:formatNumber value="${row.total}" type="number"
							groupingUsed="true"/></td>
						<td></td>
						<td></td>
					</c:when>
					<c:otherwise>
						<td>${row.vendorName}</td>
						<td><fmt:formatNumber value="${row.responders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.partialResponders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.nonResponders}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.unknown}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.total}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.thirtyDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
						<td><fmt:formatNumber value="${row.greatestDaysNonResponse}" type="number"
							groupingUsed="true"/></td>
					</c:otherwise>
				</c:choose>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<form action="responseRateReports.html">
    <input id="reportsMenuButton" tabindex="0" class="submitAnchor ui-button" type="submit" value="Reports Menu" />
</form>

<%@ include file="vendorReportStatus.jsp"%>
<%@ include file="responseRateInfo.jsp" %>
