<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">
	
	$(function() {
		$("#vendorId").change(toggleShowVendorSubtotals);
		$("#resetButton").click(resetAllInputs);
		$("input:radio").change(disableNonUsedInputs);
	});

	function toggleShowVendorSubtotals() {
		if ($("#vendorId").val() != "-1") {
			$("#showVendorSubtotals").prop("disabled", true)
		}
		else {
			$("#showVendorSubtotals").prop("disabled", false)
		}
	}
	
	function resetAllInputs() {
		$("#nationalButtonSelection").prop("checked", true);
		$("#showVendorSubtotals").prop("checked", false);
		$("#facilityIdText").val("");
		// Reset all dropdowns
		$("select option:first-child").prop("selected", "selected");
	}
	
	function disableNonUsedInputs() {
		if($("input[name=buttonSelection]:checked").val() == "2") {
			$("#visnId").attr("disabled", false);
			$("#facilityIdText").attr("disabled", true);
			$("#facilityIdSelection").attr("disabled", true);
		}
		else if($("input[name=buttonSelection]:checked").val() == "3") {
			$("#visnId").attr("disabled", true);
			$("#facilityIdText").attr("disabled", false);
			$("#facilityIdSelection").attr("disabled", false);
		}
		else {
			$("#visnId").attr("disabled", true);
			$("#facilityIdText").attr("disabled", true);
			$("#facilityIdSelection").attr("disabled", true);
		}
	}
</script>
<div id="censusReportCriteriaContainer">
<form:form method="post" action="reports.html" modelAttribute="form" name="censusActivityReportForm">
	<form:errors path="*" cssClass="error" element="div"/>
	<form:radiobutton id="radio1" path="buttonSelection" value="1" checked="checked" tabindex="0"/>
	<label><b>National Totals</b></label><br>

	<form:radiobutton id="radio2" path="buttonSelection" value="2" tabindex="0"/>
	<label><b>VISN Totals: </b></label>
	<form:select id="visnId" path="visnId" disabled="true">
		<form:option value="-1" label="All VISNs"/>
		<form:options items="${visns}" itemValue="id" itemLabel="name"/>
	</form:select><br>

	<label for="radio3">
		<form:radiobutton id="radio3" path="buttonSelection" value="3" tabindex="0"/>
		<b>Facility Totals: </b></label>
	Enter the Facility id:  
	<form:input id="facilityIdText" maxLength="6" path="facilityId" disabled="true"/> or select from the list:
	<form:select id="facilityIdSelection" path="facilityId" disabled="true">
		<form:option value="-1" label="All Facilities"/>
		<form:options items="${facilities}" itemValue="stationNumber" itemLavel="name"/>
	</form:select><br>

	Week Ending: 
	<form:select path="reportEndDate">
		<form:options items="${lastDaysOfWeek}"/>
	</form:select>
	<c:choose >
		<c:when test="${isCategoryOfCareReport}">
		<!-- do not show this attribute only used to determine COC report. -->
		<form:input type="hidden" path="modalityCode" name="drillDownVisn" value="1001"/>
		</c:when>
		<c:when test="${isResponseRateReport}">
		<!-- do not show this attribute only used to determine COC report. -->
		<form:input type="hidden" path="modalityCode" name="drillDownVisn" value="1002"/>
		</c:when>
		<c:otherwise>
			Modality: 
			<form:select path="modalityCode">
				<form:option value="-1" label="All Modalities"/>
				<form:options items="${modalities}" itemValue="code" itemLabel="description"/>
			</form:select>
		</c:otherwise>
	</c:choose>

	Vendor:
	<c:choose>
	<c:when test="${isResponseRateReport}">
		<form:select path="vendorId" disabled="true">
			<form:option value="-1" label="All Vendors"/>
		</form:select>
	</c:when>
	<c:otherwise>
		<form:select path="vendorId">
			<form:option value="-1" label="All Vendors"/>
			<form:options items="${vendors}" itemValue="id" itemLabel="name"/>
		</form:select>
	</c:otherwise>
	</c:choose><br>

	<c:choose>
		<c:when test="${isCategoryOfCareReport || isResponseRateReport}">
			<!-- do not show this attribute -->
		</c:when>
		<c:otherwise>
			<form:checkbox id="showVendorSubtotals" path="showVendorSubtotals"/>Show Vendor Subtotals
		</c:otherwise>
	</c:choose><br>
	<div id="generateReportContainer">
		<input type="submit" class="submitAnchor ui-button" id="generateReportButton"
			value="Generate Report" name="generateReportButton" tabIndex="0" />
		<input type="button" class="submitAnchor ui-button" id="resetButton"
			value="Reset" tabIndex="0" />
	</div>
</form:form>
</div>
<br><br>
<%@ include file="vendorReportStatus.jsp"%>