<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script src="js/pssReports.js"></script>

<script type="text/javascript">
	
	$(function() {
		$('#allCocCheckbox').change(function() {
			if($(this).is(':checked')) {
				$('#allExceptL2Checkbox').prop('checked', false);
				$('#nicCheckbox').prop('checked', false);
				$('#ccmCheckbox').prop('checked', false);
				$('#acmCheckbox').prop('checked', false);
				$('#hpdpCheckbox').prop('checked', false);
				$('#l2Checkbox').prop('checked', false);
			}
		});
		
		$('#allExceptL2Checkbox').change('click', function() {
			if($(this).is(':checked')) {
				$('#allCocCheckbox').prop('checked', false);
				$('#nicCheckbox').prop('checked', false);
				$('#ccmCheckbox').prop('checked', false);
				$('#acmCheckbox').prop('checked', false);
				$('#hpdpCheckbox').prop('checked', false);
				$('#l2Checkbox').prop('checked', false);
			}
		});
		
		$('#nicCheckbox, #ccmCheckbox, #acmCheckbox, #hpdpCheckbox, #l2Checkbox').change('click', function() {
			if($(this).is(':checked')) {
				$('#allCocCheckbox').prop('checked', false);
				$('#allExceptL2Checkbox').prop('checked', false);
			}
		});
	})
</script>

<div id="waitingDialog" style="display: none;">
    <strong tabindex="0">Generating Report. Please wait...</strong>
</div>

<form:form method="post" action="pssStatisticsReport.html" modelAttribute="pssReportForm">
<form:errors path="*" cssClass="error" element="div"/>
<table id="pssReportsTable">
	<tr><td colSpan="2" tabindex="0">The Patient Level of Satisfaction and the Patient Satisfaction Index
	for a set of Patient Satisfaction surveys will be displayed. 
	To define the set of surveys and the context for the surveys 
	please enter a date range and select National, VISN or facility.</td></tr>
	<tr>
		<td colSpan="2" class="centerSpan">
			<label><b>From: </b></label><form:select path="shortFormatReportFromDate">
				<form:option value="${dateTwoMonthBack}" selected="selected"/>
				<form:options items="${dateByMonths}" />
			</form:select> 
			<label><b>To: </b></label> <form:select path="shortFormatReportToDate">
				<form:options items="${dateByMonths}" />
			</form:select></td>
	</tr>
	<%@ include file="pssBaseReportsMenu.jsp" %>
	<tr>
		<td class="leftColumn" tabindex="0">Select Vendor:</td>
		<td class="rightColumn"><form:select path="vendorId">
			<form:option value="-1" label="All Vendors"/>
			<form:options items="${vendors}" itemValue="id" itemLabel="name"/>
		</form:select></td>
	</tr>
	<tr>
		<td colSpan="2" class="centerSpan">
			<form:radiobutton path="reportVersionButtonSelection" label="Patient Satisfaction Version 1.0" value="1"/>
			<form:radiobutton path="reportVersionButtonSelection" label="Patient Satisfaction Version 2.0" 
			value="2" checked="checked"/>
		</td>
	</tr>
	<tr><td class="leftColumn" tabindex="0">Include question numbers:</td>
		<td class="rightColumn"><c:forEach items="${questions }" var="question">
				<form:checkbox path="questionNumbers" label="${question.choiceText}" value="${question.choiceNumber}"/>
			</c:forEach>
		</td>
	</tr>
	<tr>
		<td class="leftColumn" tabindex="0">Category of Care: <br><i>(one must be selected;<br>can select multiples)</i>
		</td>
		<td class="rightColumn">
			<form:checkbox id="allCocCheckbox" path="categoriesOfCare" label="All" value="-1"/><br>
			<form:checkbox id="allExceptL2Checkbox" path="categoriesOfCare" label="All Except L2" value="-2" checked="checked"/><br>
			<%-- Hard coding these values, as they should not change. --%>
			<form:checkbox id="nicCheckbox" path="categoriesOfCare" label="NIC Non-Institutional Care (NIC)" value="1"/><br>
			<form:checkbox id="ccmCheckbox" path="categoriesOfCare" label="Chronic Care (CCM)" value="2"/><br>
			<form:checkbox id="acmCheckbox" path="categoriesOfCare" label="Acute Care Management (ACM)" value="3"/><br>
			<form:checkbox id="hpdpCheckbox" path="categoriesOfCare" label="Health Promotion/Disease Prevention (HPDP)" value="4"/><br>
			<form:checkbox id="l2Checkbox" path="categoriesOfCare" label="Low Acuity/Low Intensity (L2)" value="5"/><br>
		</td>
	</tr>
</table>

<div id="generateReportContainer">
	<input type="submit" class="submitAnchor ui-button" id="generateReportButton"
		value="Generate Report" name="generateReportButton" tabIndex="0" />
</div>
</form:form>
<%@ include file="pssQuestions.jsp"%>