<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/pssReports.css">

<script type="text/javascript">

	$(function() {
		var distributionReportResultsTable = $('#distributionReportResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "20%", "targets": 0},
				{"width": "15%", "targets": 1},
				{"width": "15%", "targets": 2}
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
	})
</script>

<div id="distributionReportContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="distributionReportResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<c:if test="${isBreakoutRow}">
			<th>${breakoutRow}</th>
			</c:if> 
			<th>Vendor</th>
			<th>Number of Surveys</th>
			<c:if test="${isModalityBreakoutRows}">
			<th>${modalityBreakoutRowIvr}</th>
			<th>${modalityBreakoutRowBrowser}</th>
			<th>${modalityBreakoutRowHomeDevice}</th>
			</c:if> 
				
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${report.report}" var="report">
			<tr>
				<c:if test="${isBreakoutRow}">
				<td>${report[0]}</td>
				</c:if>
				
				<td>${report[1]}</td>
				<td><fmt:formatNumber value="${report[2]}" type="number" groupingUsed="true"/></td>
				
				<c:if test="${isModalityBreakoutRows}">
				<td><fmt:formatNumber value="${report[3]}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report[4]}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report[5]}" type="number" groupingUsed="true"/></td>
				</c:if>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<%@ include file="reportsMenuButton.jsp"%>
<br>
<%@ include file="pssQuestions.jsp"%>