<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/newqir.css">

<script src="js/newQir.js"></script>
<%@ include file="inc_errors.jsp" %>
<form:form action="newQir.html" method="post"
	enctype="multipart/form-data">

	<form:errors path="*" cssClass="errorBlock" id="errorBlock"
		element="div" tabIndex="0"></form:errors>

	<div id="instructionsContainer">
		<p tabIndex="0">Please address ONLY ONE VENDOR in ANY (EACH) QIR.</p>
		<p tabIndex="0">Note: Copying and pasting text from other documents may cause unexpected characters to be saved in the QIR.</p>
	</div>

	<table>
		<tr valign="top" id="headlineContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Headline:</h4></td>
			<td><h2 class="required">*</h2></td>
			<td><form:input id="headlineInput" path="headline" size="80"
					maxlength="100" alt="Headline required field"/>
				<p id="headlineMessage" style="color: black;"></p></td>
		</tr>
		<tr valign="top" id="assignedFacilityContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Facility:</h4></td>
			<td><h2 class="required">*</h2></td>
			<td><form:select path="selectedFacilityId"
					id="selectedFacilityDropDown" alt="Facility Required field">
					<form:option value="-1" label="Select Facility" />
					<form:options items="${command.facilities}" />
				</form:select></td>
		</tr>
		<tr valign="top" id="complaintTypeContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Type of Complaint:</h4></td>
			<td></td>
			<td><form:select path="selectedQirType"
					id="selectedComplaintTypeDropDown">
					<form:option value="-1" label="Select Type" />
					<form:options items="${command.qirTypes}" />
				</form:select></td>
		</tr>
		<tr valign="top" id="orderNumberContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Contract
					or Purchase Order Number:</h4></td>
			<td></td>
			<td><form:input type="text" name="orderNumber"
					path="purchaseOrderNumber" /></td>
		</tr>
		<tr valign="top" id="deviceModelContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Device Model:</h4></td>
			<td></td>
			<td><select id="selectedDeviceDropDown">
					<option value="-1">Select Device</option>
					<c:forEach items="${command.devices}" var="device">
						<option value="${fn:escapeXml(device.key)}"><c:out
								value="${device.value}" /></option>
					</c:forEach>
			</select></td>
		</tr>
		<tr valign="top" id="deviceVendorMapContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Device
					- Vendor:</h4></td>
			<td></td>
			<td><form:select path="selectedDeviceId"
					id="selectedDeviceVendor">
					<form:option value="-1" label="Invalid" />
					<form:options items="${command.deviceVendorMap}" />
				</form:select></td>
		</tr>
		<tr valign="top" id="vendorContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Vendor:</h4></td>
			<td><h2 class="required">*</h2></td>
			<td><form:select path="" 
					id="selectedVendorDropDown"  alt="Vendor required field">
					<form:option value="-1" label="Select Vendor" />
					<form:options items="${command.vendors}" />
				</form:select></td>
			<!--  Hidden field to submit disabled vendorId with form, binds to the same Model property -->
			<td><form:select path="selectedVendorId" 
					id="selectedVendorDropDownSubmit"  alt="Vendor field is autofilled">
					<form:option value="-1" label="Select Vendor" />
					<form:options items="${command.vendors}" />
				</form:select></td>
		</tr>
		<tr valign="top" id="serialNumberContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Serial
					Number:</h4></td>
			<td></td>
			<td><form:input type="text" name="serialNumber"
					path="serialNumber" /></td>
		</tr>
		<tr valign="top" id="causeOfComplaintContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Cause
					of Complaint:</h4></td>
			<td><h2 class="required">*</h2></td>
			<td><form:textarea id="complaintArea" path="complaint" rows="4"
					cols="75"  alt="Cause of complaint required field"/>
				<p id="causeOfComplaintMessage"></p></td>
		</tr>
		<tr valign="top" id="recommendationsContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Recommendations and Remarks:</h4></td>
			<td><h2 class="required">*</h2></td>
			<td><div class="fieldGroup">
					<div id="remarksPrefix"></div>
					<form:textarea id="recommendationsArea" path="remarks" rows="4"
						cols="75"  alt="recommendations and remarks is required field"/>
					<p id="recommendationsMessage"></p>
				</div></td>
		</tr>
		<tr valign="top" id="attachmentsContainer">
			<td align="right" class="fieldLabel"><h4 tabindex="0">Attachments:</h4></td>
			<td></td>
			<td><div id="attachmentTableContainer"
					style="display: inline-block">
					<jsp:include page="inc_attachmentTable.jsp">
						<jsp:param name="showDelete" value="true" />
					</jsp:include>
				</div></td>
		</tr>
	</table>

	<div id="buttonContainer">
		<input type="submit" class="button" title="Submit" id="submit" value="Submit"
			name="Submit" tabIndex="0" onclick="return(validateForm())"/> <input type="button" class="button"
			title="Reset" id="reset" value="Reset" tabIndex="0"
			onclick="document.location.href='newQir.html'" /> <input
			type="button" class="button" title="Cancel" id="cancel" value="Cancel"
			onclick="javascript:confirmCancel();" tabIndex="0" />
	</div>

</form:form>