<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
		var nationalTotalsResultsTable = $('#nationalTotalsResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "50%", "targets": 0},
				{"width": "50%", "targets": 1}
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
	})
</script>

<div id="nationalTotalResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle }</h3>
<table id="nationalTotalsResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th alt="Modality" tabindex="0">Modality</th>
			<th alt="National Totals${vendorName}" tabindex="0">National Totals${vendorName}</th>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${nationalTotalReports}" var="report">
			<tr>
				<td>${report.modalityName}</td>
				<td><fmt:formatNumber value="${report.nationalTotal}" type="number"
					groupingUsed="true"/></td>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<%@ include file="reportsMenuButton.jsp"%>

<%@ include file="vendorReportStatus.jsp"%>