</html><%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">
<script type="text/javascript" src="js/reports.js"></script>

<script type="text/javascript">

	$(function() {
		var nationalSubtotaledResultsTable = $('#nationalSubtotaledResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "300px", "targets": 0},
				{"width": "100px", "targets": "_all"}
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
	})
	
	$("vendorId").click()
</script>

<div id="nationalSubtotaledResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="nationalSubtotaledResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th aria-label="Modality" tabindex="0">Modality</th>
			<th aria-label="Totals" tabindex="0">Totals</th>
			<c:forEach items="${vendors}" var="vendor">
				<th aria-label="${vendor.name}" tabindex="0">${vendor.name}</th>
			</c:forEach>
		</tr>
	</thead>
	<tbody>
		<c:forEach items="${nationalSubtotaledReport}" var="report">
			<tr>
				<td>${report.modalityName}</td>
				<td><fmt:formatNumber value="${report.total}"
						type="number" groupingUsed="true"/></td>
				<c:forEach items="${vendors}" var="vendor">
					<td><fmt:formatNumber value="${report.totalsMap[vendor.name]}"
						type="number" groupingUsed="true"/></td>
				</c:forEach>
			</tr>
		</c:forEach>
	</tbody>
</table>
</div>
<br>
<%@ include file="reportsMenuButton.jsp"%>

<%@ include file="vendorReportStatus.jsp"%>