<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/managescheduledjobs.css" />
<script type="text/javascript" src="js/manageScheduledJobs.js"></script>

<div id="scheduledJobTabContainer">
	<ul>
		<li><a href="#managementTab">Management</a></li>
		<li><a href="#activeTab">Active</a></li>
	</ul>
	<div id="managementTab">
		<section style="margin-top: 10px">
			<table class="stripe dt-head-left dt-body-left hover cell-border"
				id="currentJobs" style="vertical-align: top">
				<thead>
					<tr>
						<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Job Name">Job Name</a></th>
						<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Description">Description</a></th>
						<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Schedule">Schedule</a></th>
						<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Next Scheduled Date/Time">Next Scheduled Date/Time</a></th>
						<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Scheduled Job Status">Scheduled Job Status</a></th>
					</tr>
				</thead>
				<tbody>
				</tbody>
			</table>
			<button type="button" id="execute" title="Execute"
				onclick="javascript:submitJobExecution()">Execute</button>
			<button type="button" id="config" title="Config"
				onclick="javascript:popupConfigEdit()">Config</button>
			<button type="button" id="schedule" title="Schedule"
				onclick="javascript:popupScheduleEdit()">Schedule</button>
			<button type="button" id="history" title="History"
				onclick="javascript:popupHistory()">History</button>
			<button type="button" id="resumeAll"
				onclick="javascript:submitResumeAll()" title="Resume All">Resume
				All</button>
			<button type="button" id="pauseAll"
				onclick="javascript:submitPauseAll()" title="Pause All">Pause
				All</button>
			<button type="button" id="cancel"
				onclick="document.location.href='home.html'" title="Cancel">Cancel</button>
		</section>
	</div>
	<div id="activeTab">
		<section style="margin-top: 10px"></section>
		<table class="stripe dt-head-left dt-body-left hover cell-border"
			id="activeJobs" style="vertical-align: top; width: 100%">
			<thead>
				<tr>
					<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Job Name">Job Name</a></th>
					<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Start Date/Time">Start Date/Time</a></th>
					<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Run By">Run By</a></th>
					<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Status">Status</a></th>
				</tr>
			</thead>
			<tbody>
			</tbody>
		</table>
		<button type="button" id="refreshActive"
			onclick="javascript:refreshActiveJobs()">Refresh</button>
		<button type="button" id="cancelActive"
			onclick="document.location.href='home.html'">Cancel</button>
	</div>

</div>

<div id="configFieldsWrapper" style="display: none"
	title="Config Scheduled Job">
	<table>
		<tr>
			<td class="alignRightNoWrap">Job Name:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="configJobName"></span> <input type="hidden"
				id="configJobNameInput" /> <input type="hidden"
				id="configGroupName" /></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap">Description:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="configJobDescription"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap">Next Scheduled Fire Time:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="configJobNextFireTime"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap">Scheduled Job Status:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="configJobExistingStatus"></span> <input
				type="hidden" id="configJobPreviousStatus" /></td>
		</tr>
		<tr class="topVerticalAlign">
			<td class="alignRightNoWrap">E-mail Notification List:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td>To enter multiple emails, separate each address with a comma
				(,).<br> <textarea id="configJobEmails" rows="4" cols="50"
					title="Email Notification text area. To enter multiple emails, seperate each address with a comma"></textarea>
			</td>
		</tr>
		<tr>
			<td class="alignRightNoWrap"><label for="configJobStatus">Job
					Status</label>:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="configJobStatus" name="Job Status">
					<c:forEach items="${allJobStatuses}" var="status">
						<option value="${status}"><c:out value="${status}" /></option>
					</c:forEach>
			</select></td>
		</tr>
	</table>
</div>

<div id="scheduleFieldsWrapper" style="display: none"
	title="Reschedule Scheduled Job">
	<table>
		<tr>
			<td class="alignRightNoWrap" tabindex="0" aria-label="Job Name:">Job Name:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td tabindex="0"><span id="scheduleJobName"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" tabindex="0" aria-label="Description:">Description:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="scheduleJobDescription" tabindex="0"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" tabindex="0" aria-label="Next Scheduled Fire Time:">
				Next Scheduled Fire Time:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="scheduleJobNextFireTime" tabindex="0"></span></td>
		</tr>
		<tr>
			<td class="alignRightNoWrap" tabindex="0" aria-label="Scheduled Job Status:">
				Scheduled Job Status:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="scheduleJobExistingStatus" tabindex="0"></span></td>
		</tr>
		<tr class="topVerticalAlign">
			<td class="alignRightNoWrap" tabindex="0" aria-label="Job Schedule:">Job Schedule:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><span id="scheduleJobScheduleDescriptionSpan" tabindex="0"></span>
				<button type="button" id="scheduleJobChange"
					onclick="javascript:popupScheduleChange()">Change</button></td>
		</tr>
	</table>
	<%-- Populated when popping up this dialog --%>
	<input type="hidden" id="scheduleJobNameInput" /> <input type="hidden"
		id="scheduleGroupNameInput" /> <input type="hidden"
		id="scheduleTriggerNameInput" /> <input type="hidden"
		id="scheduleTriggerGroupInput" />
	<%-- Populated when popping up this dialog and also updated when changing the schedule via the popup below --%>
	<input type="hidden" id="scheduleJobCronInput" /> <input type="hidden"
		id="scheduleJobScheduleDescriptionInput" /> <input type="hidden"
		id="scheduleJobScheduleParamsCSV" />
</div>

<div id="scheduleChangeWrapper" style="display: none" title="Schedule">
	<table>
		<tr>
			<td tabindex='0' class="0">Run Frequency:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="scheduleChangeFrequency">
					<c:forEach items="${allRunFrequencies}" var="runFrequency">
						<option value="${runFrequency.code}"><c:out
								value="${runFrequency.description}" /></option>
					</c:forEach>
			</select></td>
		</tr>
		<tr class="topVerticalAlign">
			<td tabindex='0' alt="Day"  class="alignRightNoWrap">Day:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td>
				<div class="scheduleTypeFields" id="dailyWeeklyOptions"
					style="display: none">
					<input type="radio" name="scheduleType" value="1"
						style="display: none" />
					<%-- ScheduleType.WEEK_DAY --%>
					<table>
						<%-- Don't feel like trying to make this DB-driven right now - CPB --%>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="MON"> Monday</td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="TUE"> Tuesday</td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="WED"> Wednesday</td>
						</tr>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="THU"> Thursday</td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="FRI"> Friday</td>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="SAT"> Saturday</td>
						</tr>
						<tr>
							<td><input type="checkbox" name="dailyWeeklyOptions"
								value="SUN"> Sunday</td>
							<td>&nbsp;</td>
							<td>&nbsp;</td>
						</tr>
					</table>
					<input type="hidden" id="scheduleFormDaysOfWeekCSVInput" />
				</div>
				<div class="scheduleTypeFields" id="monthlyOptions"
					style="display: none">
					<table>
						<tr>
							<td><input type="radio" tabindex='0' name="scheduleType" 
								value="dayOfMonth" alt="The day of every month, for example the first day of every month, there is another option to choose, you may use down arrow key to access it"> The <select
								id="relativeDayOfMonthValue" alt="1 of 3 options" >
									<option value="1">first</option>
									<option value="L">last</option>
									<option value="15">15th</option>
							</select> day of every month</td>
						</tr>
						<tr>
							<td><input  type="radio" tabindex='0' name="scheduleType" value="weekDay" alt="The week of every month, for example the first Sunday of each month, there is another option to choose, you may use up arrow key to access it" >
								The <select id="weekOfMonth" alt="1 of 4 options"   >
									<option value="1">1st</option>
									<option value="2">2nd</option>
									<option value="3">3rd</option>
									<option value="4">4th</option>
							</select> <select id="dayOfWeek" alt="1 of 7 options">
									<option value="1">Sunday</option>
									<option value="2">Monday</option>
									<option value="3">Tuesday</option>
									<option value="4">Wednesday</option>
									<option value="5">Thursday</option>
									<option value="6">Friday</option>
									<option value="7">Saturday</option>
							</select> of every month</td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="quarterlyOptions"
					style="display: none">
					<input tabindex='0' type="radio" name="scheduleType" value="3"
						style="display: none"  />
					<%-- ScheduleType.DAY_OF_QUARTER --%>
					<table>
						<tr>
						<%-- add alt to fix 508 issue --%>
							<td>The <select tabindex='0' id="quarterlyDate" alt="The day of every quarter, the first or last day of every quarter" >
									<option value="1">first</option>
									<option value="2">last</option>
							</select> day of every quarter
							</td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="yearlyOptions"
					style="display: none">
					<table>
						<tr>
							<td><input tabindex='0' type="radio" name="scheduleType"
								value="specificDayOfYear" alt="Every Month on day of the month, for example, every Janurary on 1st day of the month, there is another option to choose, you may use down arrow key to access it"  > <%-- ScheduleType.MONTH_DAY --%>
								Every <select id="yearlyMonth" alt="1 of 12 options">
									<option value="JAN">January</option>
									<option value="FEB">February</option>
									<option value="MAR">March</option>
									<option value="APR">April</option>
									<option value="MAY">May</option>
									<option value="JUN">June</option>
									<option value="JUL">July</option>
									<option value="AUG">August</option>
									<option value="SEP">September</option>
									<option value="OCT">October</option>
									<option value="NOV">November</option>
									<option value="DEC">December</option>
							</select> on day <select id="yearlyDayOfMonth" alt="1 of 31 options">
									<option value="1">1st</option>
									<option value="2">2nd</option>
									<option value="3">3rd</option>
									<option value="4">4th</option>
									<option value="5">5th</option>
									<option value="6">6th</option>
									<option value="7">7th</option>
									<option value="8">8th</option>
									<option value="9">9th</option>
									<option value="10">10th</option>
									<option value="11">11th</option>
									<option value="12">12th</option>
									<option value="13">13th</option>
									<option value="14">14th</option>
									<option value="15">15th</option>
									<option value="16">16th</option>
									<option value="17">17th</option>
									<option value="18">18th</option>
									<option value="19">19th</option>
									<option value="20">20th</option>
									<option value="21">21st</option>
									<option value="22">22nd</option>
									<option value="23">23rd</option>
									<option value="24">24th</option>
									<option value="25">25th</option>
									<option value="26">26th</option>
									<option value="27">27th</option>
									<option value="28">28th</option>
									<option value="29">29th</option>
									<option value="30">30th</option>
									<option value="31">31st</option>
							</select> of the month</td>
						</tr>
						<tr>
							<td><input tabindex='0' type="radio" name="scheduleType"
								value="relativeDayOfYear" alt="The week of the month, for example the first Sunday of Janurary, there is another option to choose, you may use up arrow key to access it"  > <%-- ScheduleType.WEEK_DAY_MONTH --%>
								The <select id="yearlyWeekOfMonth" alt="1 of 5 options">
									<option value="1">first</option>
									<option value="2">second</option>
									<option value="3">third</option>
									<option value="4">fourth</option>
									<option value="5">last</option>
							</select> <select id="yearlyDayOfWeek" alt="1 of 7 options">
									<option value="SUN">Sunday</option>
									<option value="MON">Monday</option>
									<option value="TUE">Tuesday</option>
									<option value="WED">Wednesday</option>
									<option value="THU">Thursday</option>
									<option value="FRI">Friday</option>
									<option value="SAT">Saturday</option>
							</select> of <select id="yearlyRelativeMonth" alt="1 of 12 options">
									<option value="1">January</option>
									<option value="2">February</option>
									<option value="3">March</option>
									<option value="4">April</option>
									<option value="5">May</option>
									<option value="6">June</option>
									<option value="7">July</option>
									<option value="8">August</option>
									<option value="9">September</option>
									<option value="10">October</option>
									<option value="11">November</option>
									<option value="12">December</option>
							</select></td>
						</tr>
					</table>
				</div>
				<div class="scheduleTypeFields" id="otherOptions"
					style="display: none">
					<input tabindex='0' type="radio" name="scheduleType" value="7"
						style="display: none">
					<%-- ScheduleType.DATE --%>
					<table>
						<tr>
							<td><input type="text" id="otherDate" size="10" alt="MM/DD/YYYY"   />
								MM/DD/YYYY</td>
						</tr>
					</table>
				</div>
			</td>
		</tr>
		<tr>
			<td tabindex='0' alt="Start Time"  class="alignRightNoWrap" >Start Time:</td>
			<td class="tenPixelWidth">&nbsp;</td>
			<td><select id="scheduleChangeStartTimeHour" alt="Hours"  >
					<c:forEach begin="0" end="23" varStatus="loop">
						<option value="${loop.index}"><c:out
								value="${loop.index}" />
						</option>
					</c:forEach>
			</select> hour(s) <select id="scheduleChangeStartTimeMinute" alt="Minutes"  >
					<c:forEach begin="0" end="59" varStatus="loop">
						<option value="${loop.index}"><c:out
								value="${loop.index}" />
						</option>
					</c:forEach>
			</select> minute(s)</td>
		</tr>
	</table>
</div>

<div id="historyFieldsWrapper" style="display: none"
	title="Scheduled Job History">
	<table>
		<tr>
			<td class="alignRight"><b>Job Name:</b></td>
			<td id="historyFieldsJobName"></td>
		</tr>
		<tr>
			<td class="alignRight"><b>Description:</b></td>
			<td id="historyFieldsDescription"></td>
		</tr>
		<tr>
			<td class="alignRight"><b>Next Scheduled Date/Time:</b></td>
			<td id="historyFieldsNextScheduledTime"></td>
		</tr>
		<tr>
			<td class="alignRight"><b>Status:</b></td>
			<td id="historyFieldsStatus"></td>
		</tr>
	</table>
	<table id="jobHistoryTable">
		<thead>
			<tr>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Start Date/Time">Start Date/Time</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort End Date/Time">End Date/Time</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Run By">Run By</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Status">Status</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-lable="Press Enter to Sort Exit Status">Exit Status</a></th>
			</tr>
		</thead>
		<tbody>
		</tbody>
	</table>
</div>

<div id="historyStatsFieldsWrapper" style="display: none"
	title="Completed Scheduled Job Statistics">
	<table class="completedJobStats">
		<tr>
			<td class="alignRight" style="font-weight: bold">Name:</td>
			<td><span id="statsName"></span></td>
		</tr>
		<tr>
			<td class="alignRight" style="font-weight: bold">Statistics:</td>
			<td><textarea id="statsDetails" rows="10" cols="50"></textarea></td>
		</tr>
	</table>
</div>
