<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/manageregistrationstyle.css" />

<script type="text/javascript">
	function confirmDeny() {
		var confirmMessage = "Are you sure you want to deny this registration?";
		var doConfirm = confirm(confirmMessage);
		return doConfirm;
	}

	$(document).ready(function() {
		var table = $('#pendingRegistrations').DataTable({
			pageLength: 5,
			paging : true,
			autowidth : true,
			searching : false,
			select : 'single'
		});

		var prevSelectedIndex = -1;

		$('#pendingRegistrations tbody').on('click', 'tr', function() {
			var data = table.row(this).data();
			showDenyButton(data);
			$('#approve').css("display", "inline-block");

			if (prevSelectedIndex != -1) {
				table.row(prevSelectedIndex).deselect();
			}

			table.row(table.row(this).index()).select();
			prevSelectedIndex = table.row(this).index();

			$('#userName').val(data[0]);
		});

		$('#pendingRegistrations tbody').on('keyup', 'tr',

		function(event) {
			var keycode = (event.keyCode ? event.keyCode : event.which);
			if (keycode == '13') {

				var data = table.row(this).data();
				showDenyButton(data);
				$('#approve').css("display", "inline-block");

				if (prevSelectedIndex != -1) {
					table.row(prevSelectedIndex).deselect();
				}

				table.row(table.row(this).index()).select();
				prevSelectedIndex = table.row(this).index();

				$('#userName').val(data[0]);
			}
		});
	});

	function showDenyButton(data) {
		if (data[5] == "Submitted") {
			$('#deny').css("display", "inline-block");
		} else {
			$('#deny').css("display", "none");
		}
	}
	
	function forceFocusOnTableHeader() {
		$(this).parent().focus()	
	}
</script>

<form:form method="get" action="approveRegistration.html">
	<form:errors path="*" cssClass="errorBlock" element="div" />
	<table class="stripe dt-head-left dt-body-left hover cell-border"
		id="pendingRegistrations">
		<thead>
			<tr>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort User Name">User Name</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Name">Name</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort VISN">VISN</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Facility">Facility</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Phone">Phone</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Registration Status">Registration Status</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Job Description">Job Description</a></th>
				<th><a href="javascript:forceFocusOnTableHeader()" aria-label="Press Enter to Sort Denied Reason">Denied Reason</a></th>
			</tr>
		</thead>
		<tbody>
			<c:forEach items="${users}" var="user">
				<tr>
					<td tabindex="0"><c:out value="${user.userName}" /></td>
					<td tabindex="0"><c:out value="${user.familyName}" />, <c:out value="${user.givenName}" /></td>
					<td tabindex="0"><c:out value="${user.visn.label}" /></td>
					<td tabindex="0"><c:out value="${user.facility.label}" /></td>
					<td tabindex="0"><c:out value="${user.telephoneNumber}" /></td>
					<td tabindex="0"><c:out value="${user.registrationStatus.label}" /></td>
					<td tabindex="0"><c:out value="${user.description}" /></td>
					<td tabindex="0"><c:out value="${user.registrationDeniedReason.label}" /></td>
				</tr>
			</c:forEach>
		</tbody>
	</table>
	
	<input type="submit" class="button" title="Approve" id="approve" value="Approve"
		name="Approve" tabIndex="0" />
	<input type="submit" class="button" title="Submit" id="deny" value="Deny" name="Deny"
		onclick="return(confirmDeny());" tabIndex="0" />
	<input type="button" class="button" title="Cancel" id="cancel" onclick="location.href='home.html'"
		value="Cancel" tabIndex="0" />
	<input id="userName" name="userName" type="hidden" value=" "
		path="userName" />

</form:form>

