<%@ include file="inc_header.jsp"%>

<script type="text/javascript">
	skipSpinnerOnAjaxStart = false
	defeatHideAjaxSpinner = false

	$(function() {
		hideSpinner()
		$(document).ajaxStart(function() {
			if (!skipSpinnerOnAjaxStart) {
				showSpinner()
			}
		})
		$(document).ajaxStop(hideSpinner)
		$(document).ajaxError(hideSpinner)
	})

	function hideSpinner() {
		if (!defeatHideAjaxSpinner) {
			$("#spinner").hide()
			$("#spinnerMessage").hide()
			$("#spinner").css('z-index', '1')
		}
	}

	function showSpinner(addlText, showSpinnerUntilPageRefresh) {
		if (showSpinnerUntilPageRefresh) {
			defeatHideAjaxSpinner = true
		}

		var topDomZIndex = $.topZIndex("div")
		$("#spinner").show()
		$("#spinner").css('z-index', topDomZIndex + 1)
		$("#spinnerMessage").toggle($.trim(addlText) != '')
		$("#spinnerMessage p").text($.trim(addlText) != '' ? addlText : '')
		$("#spinnerMessage").css('z-index', topDomZIndex + 2)
	}
</script>



<div id="spinner" class="spinner" style="display: none">
	<img id="img-spinner" src="images/spinner.gif" alt="Loading" />
</div>
<div id="spinnerMessage" class="spinnerMessage" style="display: none">
	<p></p>
</div>