<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/editqir.css">

<script type="text/javascript">
	var isReadOnly = <c:out value="${command.readOnly}" default="false" />
	var isVendor = <c:out value="${userIsVendor}" default="false" />
	var isNationalAdmin = <c:out value="${userIsNationalAdmin}" default="false" />
	var qirStatusTypeCode = "<c:out value="${command.qirStatusType.code}" />"
	var canEditIsDmpIssue = <c:out value="${canEditIsDmpIssue}" default="false" />

	function printQIR() {
		var selected = $('#selectedQIR').val();
		if (selected != null)
			window.open('viewQir.html?qirId=' + selected);
	}

	function confirmCancel() {
		confirmDialog("All unsaved data will be lost. Do you still want to cancel?", function() {
			document.location.href = "<c:out value="${command.fromPage}" />"
		},{
			okButtonLabel : 'Yes',
			cancelButtonLabel : 'No'
		})
	}

	function confirmWithdraw() {
		
		if(validateForm()) {
			return confirm("Withdraw QIR. This QIR will no longer be available for processing. Do you want to withdraw it?");
		}
		else {
			return false;
		}
	}

	function stripLastCharacter(arg, legalLength) {
		var length = arg.length;
		var retVal = arg.slice(0, (legalLength));

		return retVal;
	}

	$(function() {
		if (!isReadOnly) {
			$(".editButton").show()
		} else {
			disableAttachmentTable()
			$(".editField").prop('disabled', true)
		}

		$("#recAndRemarksArea").html("");
		$("#recAndRemarksHistoryArea").prop("disabled", true)

		$("#editQirContainer").tabs({
			heightStyle : "content"
		})
		
		$("#isDmpIssueDropDown").change(showDmpIssueTypeContainer)

		$('#complaintArea').on('keyup', function(event) {
			var length = $("#complaintArea").val().length
			$("#causeOfComplaintMessage").text(length + " of 2000 characters used.")
		})
		$('#recAndRemarksArea').on('keyup', function(event) {
			var length = $("#recAndRemarksArea").val().length
			$("#recommendationsMessage").text(length + " of 2000 characters used.")
		})
		$('#vendorActions').on('keyup', function(event) {
			var length = $("#vendorActions").val().length
			$("#vendorActionsMessageCount").text(length + " of 2000 characters used.")
		})
		
		// Call to initialize according to actual isDmpIssue value
		// for selected QIR
		showDmpIssueTypeContainer()

		if (isVendor && qirStatusTypeCode == '2' /* Approved */) {
			$("#editQirContainer").tabs("option", "active", 2)
		}
		
		forceFocusOnInfoMessage()
	})
	
	function showDmpIssueTypeContainer() {  // not sure if used? also done is JSTL. Pretty sure depricated. 
		if ($("#isDmpIssueDropDown").val() === "Y") {
				$("#dmpQirTypeDropDown").css('display', 'inline')
				$("#dmpIssueTypeContainer .required").css('display', 'inline')
		} 
		else {
				$("#dmpQirTypeDropDown").hide()
				$("#dmpQirTypeDropDown").val("-1")
				$("#dmpIssueTypeContainer .required").hide()
		}
	}

	function forceFocusOnInfoMessage() {

		if($('#informationMessageDiv').is(':visible')){	
			$('#informationMessageDiv p:first').focus()	
		}
		
		if($('#errorsWrapper').is(':visible')){	
			$('#errorsWrapper span:first').focus()	
		}

	}
</script>
<script src="js/editQir.js"></script>
<%@ include file="inc_errors.jsp" %>
<form:form method="post" action="editQir.html" enctype="multipart/form-data">
	<form:input type="hidden" name="fromPage" path="fromPage" value="${command.fromPage}" />
	<div id="instructionsContainer">
		<p tabIndex="0">Note: Copying and pasting text from other documents may cause unexpected characters to be saved in the QIR.</p>
	</div>
	<p id="title">
		<c:out value="${title}" />
	</p>
	<div id="editQirContainer">
		<ul>
			<li><a href="#summaryTab">Summary</a></li>
			<li><a href="#recAndRemarksTab">Recommendations And Remarks</a></li>
			<li><a href="#vendorActionsTab">Vendor Actions</a></li>
			<li><a href="#attachmentsTab">Attachments</a></li>
		</ul>
		<div id="summaryTab">
			<table>
				<tr valign="top" id="statusContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Status:</h4>
						<span class="invisibleRequiredFor508">*</span></td>
					<td><h2 class="required">*</h2></td>
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.qirStatusType.name}" />
						</h4></td>
				</tr>
				<tr valign="top" id="tnContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Tracking
							Number:</h4></td>
					<td></td>
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.id}" />
						</h4> <input id="selectedQIR" name="selectedQIR" type="hidden"
						value="${fn   :escapeXml(command.id)}" path="selectedQIR" class="editField" /></td>
				</tr>
				<tr valign="top" id="headlineContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Headline:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.headline != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.headline}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="submittedDateContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Submitted
							Date:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.submittedDateAsString != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.submittedDateAsString}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="submittedByContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Submitted
							By:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.submittedByName != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.submittedByName}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="facilityContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Facility:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.facilityNumAndName != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.facilityNumAndName}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="typeOfComplaintContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Type 	of Complaint:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.qirType.label != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.qirType.label}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				</tr>
				<tr valign="top" id="isDmpIssueContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">DMP Issue:</h4></td>
						<c:choose>
							<c:when test="${canEditIsDmpIssue}">
								<span class="invisibleRequiredFor508">*</span>
								<td><h2 class="required">*</h2></td>
								<td>
								<form:select path="isDmpIssue" id="isDmpIssueDropDown"
									cssClass="editField" required="true">
									<form:option value="S" label="Select" />
									<form:option value="Y" label="Yes" />
									<form:option value="N" label="No" />
								</form:select>
								</td>
							</c:when>
							<c:otherwise>
								<td></td>
								<td>
								<c:if test="${command.isDmpIssue == 'N'}">
									<h4 id="value" tabindex="0">No</h4>
									<form:hidden path="isDmpIssue" value="${command.isDmpIssue}"/>
								</c:if>
								<c:if test="${command.isDmpIssue == 'Y'}">
									<h4 id="value" tabindex="0">Yes</h4>
									<form:hidden path="isDmpIssue" value="${command.isDmpIssue}"/>
								</c:if>
								</td>
							</c:otherwise>
						</c:choose>
					
				</tr>
				<tr valign="top" id="dmpIssueTypeContainer">
				<td align="right" class="fieldLabel"><h4 tabindex="0">DMP Issue Type:</h4> 
				
				<span class="invisibleRequiredFor508">*</span></td>
				<c:choose>
							<c:when test="${canEditIsDmpIssue}">
								<td><h2 class="required">*</h2></td>
								<td><c:if test="${canEditIsDmpIssue}">
							<form:select path="selectedDmpQirTypeId" id="dmpQirTypeDropDown"
								cssClass="editField"  required="true">
								<form:option value="-1" label="Select" />
								<form:options items="${command.dmpQirTypes}" />
							</form:select>
						</c:if></td>
							</c:when>
							<c:otherwise>
								<td></td>
								<td><h4 id="value" tabindex="0">
								<c:out value="${dmpType}"></c:out>
								</h4>
								<form:hidden path="selectedDmpQirTypeId" value="${dmpTypeId}"/></td>
							</c:otherwise>
						</c:choose>
				</tr>
				
				<tr valign="top" id="orderNumberContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Contract
							or Purchase Order Number:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.purchaseOrderNumber != null}">
						<td><h4 id="value" tabindex="0">
							<c:out value="${command.purchaseOrderNumber}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
				
				</tr>
				<tr valign="top" id="deviceModelContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Device
							Model:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.deviceType.label != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.deviceType.label}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="vendorContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Vendor:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.vendor.label != null}">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.vendor.label}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="serialNumberContainer">
					<td align="right" class="fieldLabel"><h4 tabindex="0">Serial
							Number:</h4></td>
					<td></td>
					<c:choose>
					<c:when test = "${command.serialNumber != null and not empty command.serialNumber }">
					<td><h4 id="value" tabindex="0">
							<c:out value="${command.serialNumber}" />
						</h4></td>
					</c:when>
					<c:otherwise><td></td></c:otherwise>
					</c:choose>
					
				</tr>
				<tr valign="top" id="complaintContainer">

					<c:choose>
						<c:when test="${userIsVendor}">
							<td align="right" class="fieldLabel"><label tabindex="0" class="ihtaLabel" >Cause of Complaint:</label></td>
							<td></td>
							<td><form:textarea id="complaintArea" path="complaint" maxlength="2000" 
									rows="4" cols="75" disabled="true" cssClass="editField" />
								<p id="causeOfComplaintMessage"></p></td>
						</c:when>
						<c:otherwise>
							<td align="right" class="fieldLabel">
							<h4 tabindex="0" class="ihtaLabel">Cause of Complaint:</h4>
							<span class="invisibleRequiredFor508">*</span></td>
							<td><h2 class="required">*</h2></td>
							<td>
								<form:textarea id="complaintArea" path="complaint"
									rows="4" cols="75" disabled="false" cssClass="editField" alt="required field"/>
								<p id="causeOfComplaintMessage"></p>
							</td>
						</c:otherwise>
					</c:choose>
				</tr>
			</table>
			
			

		</div>
		<div id="recAndRemarksTab">
			<table>
				<c:if test="${enableRemarks}">
					<tr valign="top">
						<td align="right" class="fieldLabel">
						<label tabindex="-1" class="ihtaLabel" for="recAndRemarksArea">Recommendations And Remarks:</label></td>
						<td><h2 class="required">*</h2></td>
						<td><form:textarea id="recAndRemarksArea" path="remarks" alt="recommendations and remarks is required field" maxlength="2000"
								rows="10" cols="75" cssClass="editField" />
							<p id="recommendationsMessage"></p></td>
					</tr>
				</c:if>
				<tr valign="top">
					<td align="right" class="fieldLabel">
					<label tabindex="-1" class="ihtaLabel" for="recAndRemarksHistoryArea">Recommendations And Remarks History:</label>
					</td>
					<td></td>
					<td><form:textarea id="recAndRemarksHistoryArea"
							path="remarksHistory" rows="10" cols="75" cssClass="editField" /></td>
				</tr>
			</table>
		</div>
		<div id="vendorActionsTab">
			<table>
				<c:if test="${showVendorResponseDueDate}">
					<tr valign="top">
						<td align="right" class="fieldLabel"><h4 tabindex="0"
								style="color: Green;">Vendor Response Due:</h4></td>
						<td></td>
						<td><h4 id="value" tabindex="0" style="color: Green;">
								<c:out value="${vendorResponseDueDateAsString}" />
							</h4></td>
					</tr>
				</c:if>
				<c:if test="${userIsVendor}">
					<tr valign="top" id="vendorActionsContainer">
						<td align="right" class="fieldLabel">
						<label tabindex="-1" class="ihtaLabel" for="vendorActions">Vendor Actions:</label>
						</td>
						<td><h2 class="required">*</h2></td>
						<td><form:textarea id="vendorActions" path="vendorActions"
								rows="10" cols="75" cssClass="editField"  alt="Vendor required field"/>
							<p id="vendorActionsMessageCount"></p></td>
					</tr>
				</c:if>
				<tr valign="top" id="vendorActionsHistoryContainer">
					<td align="right" class="fieldLabel">
					<label tabindex="-1" class="ihtaLabel" for="vendorActionsHistory">Vendor Actions History:</label>
					</td>
					<td></td>
					<td><form:textarea id="vendorActionsHistory"
							path="vendorActionsHistory" rows="10" cols="75" disabled="true"
							cssClass="editField" /></td>
				</tr>
			</table>
		</div>
		<div id="attachmentsTab">
			<div id="informationMessageContainer">
				<h5 id="informationMessage" tabindex="0">The total size of all
					attachments should not exceed 5 MB.</h5>
			</div>
			<div id="attachmentsContainer" style="display: inline-block">
				<c:set var="attachmentTableInitialValues"
					value="${command.attachments}" scope="request" />
				<jsp:include page="inc_attachmentTable.jsp">
					<jsp:param name="showDelete" value="false" />
				</jsp:include>
			</div>
		</div>
	</div>

	<div id="buttonContainer">
	
		<c:if test="${canSubmit}">
		<input type="submit" class="submitAnchor button editButton" id="Update"
			value="Update" name="Update" onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canApprove}">
			<input type="submit" class="submitAnchor button editButton" id="Approve"
				value="Approve" name="Approve"  onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canWithdraw}">
			<input type="submit" class="submitAnchor button editButton" id="Withdraw"
				value="Withdraw" name="Withdraw"
				onclick="return(confirmWithdraw());" />
		</c:if>
		<c:if test="${canAgree}">
			<input type="submit" class="submitAnchor button editButton" id="Agree"
				value="Agree" name="Agree" />
		</c:if>
		<c:if test="${canReply}">
			<input type="submit" class="submitAnchor button editButton" id="Reply"
				value="Reply" name="Reply" onclick="return(validateForm())" />
		</c:if>
		<c:if test="${canClose}">
			<input type="submit" class="submitAnchor button editButton" id="Close"
				value="Close" name="Close" onclick="return(validateForm())" />
		</c:if>
		<input type="button" class="submitAnchor button" id="pdf" value="PDF" name="PDF"
			onclick="printQIR()" /> <input type="button" class="submitAnchor button"
			value="Cancel"
			onclick="confirmCancel()" />
	</div>
	
	<!-- Add all hidden fields that will always be needed, like id -->
	<form:hidden path="id"/>
	<form:hidden path="headline"/>
	<c:if test="${userIsVendor}">
		<%-- If the user is a vendor, the cause of complaint text is disabled and therefore does not get bound by Spring --%>
		<form:hidden path="complaint"/>
	</c:if>
	
</form:form>

