<%@ include file="inc_header.jsp"%>

<link rel="stylesheet" href="css/reports.css">

<script type="text/javascript">

	$(function() {
		var catOfCareVisnTotalsResultsTable = $('#catOfCareVisnTotalsResultsTable').DataTable({
			paging : false,
			autowidth : false,
			searching : false,
			ordering : false,
			info : false,
			"columnDefs": [
				{"width": "40%", "targets": 0},
				{"width": "25%", "targets": 1},
				{"width": "25%", "targets": 2}
			],
			"language" : {
				// Messages used in the case that selections render no data.
				"emptyTable" : "No data found.",
				"infoEmpty" : "No data found."
			}
		});
		
	})
</script>

<div id="visnTotalResultsContainer">
<h3 id="reportTitle" tabindex="0">${reportTitle}</h3>
<table id="catOfCareVisnTotalsResultsTable" class="compact stripe dt-head-left dt-body-left hover cell-border">
	<thead>
		<tr>
			<th aria-label="VISN" tabindex="0">VISN</th>
			<th aria-label="Non-institutional Care (NIC)" tabindex="0">Non-institutional Care (NIC)</th> 
			<th aria-label="Non-Institutional Care Low Responder (NICLR)" tabindex="0">Non-Institutional Care Low Responder (NICLR)</th>
			<th aria-label="Chronic Care Management" tabindex="0">Chronic Care Management</th>
			<th aria-label="Acute Care Management" tabindex="0">Acute Care Management</th>
			<th aria-label="Health Promotion/Disease Prevention" tabindex="0">Health Promotion/Disease Prevention</th>
			<th aria-label="L2 - Low Acuity/Low Intensity" tabindex="0">L2 - Low Acuity/Low Intensity</th>
			<th aria-label="Totals" tabindex="0">Totals</th>
		</tr>
	</thead>
	<tbody>
	<c:if test="${dataPresent}">
	<!-- Vendor Totals Row, has some different Columns, must be done sepretly  -->
		<c:forEach begin="0" end="${vendorReportsSize}" items="${categoryOfCareReport}" var="report">
			<tr>
				<td>
					<form:form method="post" action="reports.html" commandName="form" class="inline">
						<input type="hidden" name="cocDrillDownVisn" value="true"/>
						<form:hidden path="visnId" value="${report.visnId}"/>
						<form:hidden path="vendorId" value="${vendorId}"/>
						<form:hidden path="reportEndDate" value="${reportEndDate}"/>
						<button type="submit" value="Submit" class="link-button">
						${report.name}</button>
					</form:form>
				</td>
				<td><fmt:formatNumber value="${report.nic}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.niclr}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.chronicCareMgnt}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.acuteCareMgnt}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.hpdp}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.lowActLowInt}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${report.total}" type="number" groupingUsed="true"/></td>
			</tr>
	<!-- Percents Row, has different Columns, must be done separtly  -->
		</c:forEach>
			<tr>
				<td>${categoryOfCareReport[vendorReportsSize+1].rowName}</td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].nic}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].niclr}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].chronicCareMgnt}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].acuteCareMgnt}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].hpdp}" type="number" groupingUsed="true"/></td>
				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+1].lowActLowInt}" type="number" groupingUsed="true"/></td>
				<td>${categoryOfCareReport[vendorReportsSize+1].columnName}</td>
			</tr>
			<tr>
				<td>${categoryOfCareReport[vendorReportsSize+2].rowName}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].nicPercentTotal}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].niclrPercentTotal}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].chronicCareMgntPercentTotal}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].acuteCareMgntPercentTotal}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].hpdpPercentTotal}</td>
				<td>${categoryOfCareReport[vendorReportsSize+2].lowActLowIntPercentTotal}</td>
 				<td><fmt:formatNumber value="${categoryOfCareReport[vendorReportsSize+2].totalsTotal}" type="number" groupingUsed="true"/></td>
 			</tr>
 		</c:if>
	</tbody>
</table>
</div>
<br>
<%@ include file="reportsMenuButton.jsp"%>

<%@ include file="cocNICMessage.jsp"%>
