


<!DOCTYPE html>
<%@ page session="false" contentType="text/html; charset=UTF-8" %>
<%@page import="org.springframework.web.context.support.WebApplicationContextUtils" %>
<%@page import="org.springframework.web.context.WebApplicationContext" %>
<%@page import="gov.va.med.fw.util.VersionInfo" %>
<%@page import="gov.va.med.fw.security.SecurityContext"%>
<%@page import="gov.va.med.fw.security.SecurityContextHelper"%>
<%@page import="gov.va.med.fw.security.UserPrincipal"%>
<%@page import="gov.va.med.fw.service.config.EnvironmentParamService"%>
<%
	
	HttpServletResponse httpResponse = (HttpServletResponse) response;
	httpResponse.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1
	httpResponse.setHeader("Pragma", "no-cache"); // HTTP 1.0
	
	String versionNumber = (String)application.getAttribute("CCHT_VERSION_NUMBER");
	if(versionNumber == null || versionNumber.length() == 0) {
	    WebApplicationContext locator = 
	    WebApplicationContextUtils.getWebApplicationContext(application);
		if (locator != null) {
			VersionInfo versionInfo = (VersionInfo)locator.getBean("cchtVersionInfo");		 
			if(versionInfo != null) {
				versionNumber = versionInfo.getVersion();
				application.setAttribute("CCHT_VERSION_NUMBER",versionNumber);
			}
		}
	}

 	boolean showNoticeOfTestEnvironment = false;
 	String piiMessage="Do NOT enter any Personally Identifiable Information (PII) into this system!";
	application.setAttribute("piiMessage", piiMessage);			
	SecurityContext securityContext = SecurityContextHelper.getSecurityContext();
	UserPrincipal user = (securityContext != null) ? securityContext.getUserPrincipal() : null;	
	String loggedInUserName = (user != null && !user.isAnonymous()) ? user.getFullName() : "";
	if (loggedInUserName == null) loggedInUserName = "";
	
	application.setAttribute("User", user);
	
%>

<html xmlns="http://www.w3.org/1999/xhtml" lang="en" xml:lang="en">
    <head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
        <title>CCHT</title>
        <meta http-equiv="CACHE-CONTROL" content="NO-CACHE">
		<META HTTP-EQUIV="Pragma" CONTENT="no-cache"/>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
		<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
		<link rel="stylesheet" href="css/styles.css?v=1.0">
		<link rel="stylesheet" href="css/footer.css">
		<link rel="stylesheet" href="css/menustyle.css">
		
	
		
<script language="javascript">

	function logoutConfirm()
	{
	  var confirmMessage = "Changes that are not saved will be lost!  \n\n Do you want to logout ?";
	  return confirm(confirmMessage);
	}

	function autoLogout()
	{
		document.logoutform.submit();
	}
	
	function setFocus()
	{
		window.focus();
	}
	function scrollToTop() {
	   window.scrollTo(0, 0);
	}
		
	function expandOrCollapseIt(elementName) {
	    var whichEl = document.getElementById(elementName);
	    if(whichEl != null) {
		whichEl.style.display = (whichEl.style.display == "inline" ) ? "none" : "inline";
	    }
	}
	
</script>
 

    </head>
    <body>
		
		<div class="container">
			<header>
				<jsp:include page="banner.jsp" />
			</header>
			
			<footer>			
				<jsp:include page="footer.jsp" />			
			</footer>
		</div>
		
	    <!-- include jquery -->
	    <script src="js/jquery-1.12.3.min.js"></script>

	    <!-- include the jquery-accessibleMegaMenu plugin script -->
	    <script src="js/jquery-accessibleMegaMenu.js"></script>

	    <!-- initialize a selector as an accessibleMegaMenu -->
	    <script src="js/cchtmenu.js"></script>
   </body>
</html>
