$(function() {
	prepareSelectedFacility()
	prepareSelectedDevice()
	prepareHeadline()
	prepareComplaint()
	prepareRecommendations()

	if ($("#errorBlock").is(":visible")) {
		var errorMessages = $('#errorBlock').text();

		if (errorMessageContains(errorMessages, "Headline")) {
			$("#headlineInput").css("border-color", "red");
		}

		if (errorMessageContains(errorMessages, "Facility")) {
			$("#selectedFacilityDropDown").css("border-color", "red");
		}

		if (errorMessageContains(errorMessages, "Vendor")) {
			$("#selectedVendorDropDown").css("border-color", "red");
		}

		if (errorMessageContains(errorMessages, "Cause of Complaint")) {
			$("#complaintArea").css("border-color", "red");
		}

		if (errorMessageContains(errorMessages, "Recommendations and Remarks")) {
			$("#recommendationsArea").css("border-color", "red");
		}
	}
	
	forceFocusOnInfoMessage()
})

function confirmCancel() {
	confirmDialog("All unsaved data will be lost. Do you still want to cancel?", function() {
		document.location.href = 'home.html'
	},{
		okButtonLabel : 'Yes',
		cancelButtonLabel : 'No'
	})
}

function stripLastCharacter(arg, legalLength) {
	var length = arg.length;
	var retVal = arg.slice(0, (legalLength));

	return retVal;
}

function setRemarksPrefix() {
	var t = $("#selectedFacilityDropDown option:selected")
	if (t.length > 0 && t.val() != '-1' && t.text() != '') {
		$("#remarksPrefix").text(t.text() + ' -')
	} else {
		$("#remarksPrefix").empty()
	}
}

function prepareSelectedFacility() {
	$("#selectedFacilityDropDown").change(setRemarksPrefix)
}

function prepareSelectedDevice() {
	
		$("#selectedVendorDropDownSubmit").css("visibility", "collapse");
	
	    $('#selectedDeviceDropDown').change(function() {

	    	// clear any previous vendor data in case new device has inactive vendor
	    	$("#selectedDeviceVendor").val("-1"); 
	    	$("#selectedVendorDropDown").val("-1");
	    	$("#selectedVendorDropDownSubmit").val("-1");
	    	
	    	var id = $("#selectedDeviceDropDown").val();
	    	
	    	$("#selectedVendorDropDown").prop("disabled", id > -1)
	    	$("#vendorRequired").css("display", id > -1 ? "none" : "inline")
	    	
			if (id > -1) {
				
				
				$("#selectedDeviceVendor").val(id)
				var vendorId = $("#selectedDeviceVendor option:selected")
						.text();
	
				var exists = 0 != $('#selectedVendorDropDown option[value='
						+ vendorId + ']').length;
	
				if (exists) {
					
					$("#selectedVendorDropDown").val(vendorId);
					$("#selectedVendorDropDownSubmit").val(vendorId);
				}
			}
			else {
				$("#selectedVendorDropDown").val("-1");
				$("#selectedVendorDropDownSubmit").val("-1");
				$("#selectedDeviceDropDown").val("-1");
				$("#selectedDeviceVendor").val("-1");
			}
	    }).change(); // Trigger the event
}

function prepareHeadline() {
	$('#headlineInput').on('keyup', function(event) {
		var length = $("#headlineInput").val().length;

		if (length > 49) {
			$("#headlineInput").attr('rows', '2');
		} else {
			$("#headlineInput").attr('rows', '1');
		}

		if (length > 100) {
			var currentMessage = $("#headlineInput").val();
			var strippedMessage = stripLastCharacter(currentMessage, 2000);
			$("#headlineInput").val(strippedMessage);
			length = $("#headlineInput").val().length;
		}
		var message = length + " of 100 characters used.";

		$("#headlineMessage").text(message);
	})
}

function prepareComplaint() {
	$('#complaintArea').on('keyup', function(event) {
		var length = $("#complaintArea").val().length;

		if (length > 2000) {
			var currentMessage = $("#complaintArea").val();
			var strippedMessage = stripLastCharacter(currentMessage, 2000);
			$("#complaintArea").val(strippedMessage);
			length = $("#complaintArea").val().length;
		}
		var message = length + " of 2000 characters used.";

		$("#causeOfComplaintMessage").text(message);
	})
}

function prepareRecommendations() {
	$('#recommendationsArea').on('keyup', function(event) {
		var length = $("#recommendationsArea").val().length;

		if (length > 2000) {
			var currentMessage = $("#recommendationsArea").val();
			var strippedMessage = stripLastCharacter(currentMessage, 2000);
			$("#recommendationsArea").val(strippedMessage);
			length = $("#recommendationsArea").val().length;
		}
		var message = length + " of 2000 characters used.";

		$("#recommendationsMessage").text(message);
	})
	
	setRemarksPrefix()
}

function errorMessageContains(errorMessage, arg) {
	return errorMessage.search(arg) > -1
}

function validateForm() {
	var errors = new Array()
	
	var headlineInput = $.trim($("#headlineInput").val())
	var selectedFacilityDropDown = $("#selectedFacilityDropDown").val()
	var selectedVendorDropDown = $("#selectedVendorDropDown").val()
	var complaintArea = $.trim($("#complaintArea").val())
	var recommendationsArea = $.trim($("#recommendationsArea").val())
	
	if (headlineInput == '') {
		errors.push({ field : 'name', message : 'Headline is required.' })
	}
	
	if (selectedFacilityDropDown < 1) {
		errors.push({ field : 'name', message : 'Facility is required.' })
	}
	
	if (selectedVendorDropDown < 1) {
		errors.push({ field : 'name', message : 'Vendor is required.' })
	} 
	else { // if not empty set hidden field.
		$("#selectedVendorDropDownSubmit").val(selectedVendorDropDown);
	}
	
	if (complaintArea == '') {
		errors.push({ field : 'name', message : 'Cause of Complaint is required.' })
	}
	
	if (recommendationsArea == '') {
		errors.push({ field : 'name', message : 'Recommendations and Remarks are required.' })
	}
	
	if (errors.length > 0) {
	
		showErrors(errors)
		 forceFocusOnErrorMessage()
		return false
	}	
	
	 
	return true
}

	function forceFocusOnErrorMessage() {		
		if($('#errorsWrapper').is(':visible')){	
			$('#errorsWrapper span:first').focus()	
		}

	}
	
		function forceFocusOnInfoMessage() {	

		if($('#informationMessageDiv').is(':visible')){	
			$('#informationMessageDiv p:first').focus()	
		}

	}
	
