var selectedRoles = [];
$(function() {
	$("#datepicker").datepicker()
	$("#assignedUserGroup").val('20071')
	$("#assignedUserGroup").hide()
	$("#assignedUserGroupText").text('VA User')

	$("#assignedRegistrationStatus").val('20082')
	$("#assignedRegistrationStatus").hide()
	$("#assignedRegistrationStatusText").text('Approved')

	$("#assignedJobDescription").prop("disabled", true)
	$("#assignedUserGroupSelect").prop("disabled", true)
	$("#assignedRegistrationStatusSelect").prop("disabled", true)
	$("#jobDescriptionsSelect").prop("disabled", true)

	setSelectedRolesArray()
	rolesUpdated()
	
	$('#availableRoles span input').change(
		function() {
			
			
			if( $(this).is(':checked') )
			{
				selectedRoles.push($(this).val().toString())			
				rolesUpdated()
			}
			else
			{
				var index = selectedRoles.indexOf($(this).val().toString());
				selectedRoles.splice(index, 1)				
				rolesUpdated()
			}
			
			
		}
	);
	

	// Remove required marker if we are currently
	// denying the user.
	if( $("#isDeny").val() == "true" )
	{
		$(".ms-selection .custom-header h2").css('display', 'none');
	}
	
	// Disable Registration Denied Reason dropdown if user can't edit	
	if( $("#disableRegDeniedDropdown").val() == "true" ) {
		$('#assignedRegistrationDenied').prop("disabled", true)
		$(".ms-selection .custom-header h2").css('display', 'none');
	}
	
	
	
	$('#inactive').change(function() {
		showInactiveProperties()
	})

	$('#addRole').click(function() {
		var result = new Array()
		$('#availableRoles option:selected').each(function() {
			result.push($this.val())
		})
		
		return false
	})

	
	
	showInactiveProperties()
	
	
})


/**
 * Set selectedRoles based on current assigned roles.
 * This is brute force and needs to be replaced.
 */
function setSelectedRolesArray() {
	
	if($('#showRoles').val() == 'false') {
		$('#availableRoles').hide();
	}
	
	var canEditPage = $('canEditPage').val();
	if(canEditPage == 'false') {
		$('#availableRoles').hide();
	}
	
	selectedRoles = [];
	
	var isNationalAdmin = $('#isNationalAdmin').val();
	if(isNationalAdmin == "true") {
		selectedRoles.push("National Administrator");
	}

	var isAppAdmin = $('#isAppAdmin').val();
	if(isAppAdmin == "true") {
		selectedRoles.push("Application Administrator");
	}

	var isCareCoordinator = $('#isCareCoordinator').val();
	if(isCareCoordinator == "true") {
		selectedRoles.push("Care Coordinator");
	}
	
	var isFacilityAdmin = $('#isFacilityAdmin').val();
	if(isFacilityAdmin == "true") {
		selectedRoles.push("Facility Administrator");
	}	

	var isOTS = $('#isOTS').val();
	if(isOTS == "true") {
		selectedRoles.push("OTS Contract Manager");
	}
	var isPSA = $('#isPSA').val();
	if(isPSA == "true") {
		selectedRoles.push("Program Support Assistant");
	}	
	
	var isQIR = $('#isQIR').val();
	if(isQIR == "true") {
		selectedRoles.push("QIR Originator");
	}

	var isReportsOnly = $('#isReportsOnly').val();
	if(isReportsOnly == "true") {
		selectedRoles.push("Reports Only");
	}
		
	var isVendor = $('#isVendor').val();
	if(isVendor == "true") {
		selectedRoles.push("Vendor");
	}
	
	var isVisnAdmin = $('#isVisnAdmin').val();
	if(isVisnAdmin == "true") {
		selectedRoles.push("VISN Administrator");
	}
	

	var isManagement = $('#isManagement').val();
	
	if(isManagement == "true") {
		selectedRoles.push("Management");
	}
	
	
}



/**
 * Hide or show date input and reason dropdown
 * according the inactive checked state. 
 */
function showInactiveProperties() {
	if ($('#inactive').is(':checked')) {
		$('#inactivateDate').css("display", "block")
		$('#inactivateReason').css("display", "block")
	} else {
		$('#inactivateDate').css("display", "none")
		$('#inactivateDate').val('')
		$('#inactivateReason').css("display", "none")
	}
}


/**
 * Enable or disable VISN, Facility and Vendor screen items based on
 * the currently selected roles.
 * 
 * This is pretty much a copy of flex based mxml code we have migrated from.
 */
function rolesUpdated() {

	if(selectedRoles.length < 1) {

		
		$('#assignedVisnIdSelect').css('display', 'inline')
		$('#assignedVisnIdSelect').attr('alt', 'Assigned Visn')
		$('#assignedVisnContainer .required').css('display', 'none')
		
		
		$('#assignedFacilityIdSelect').css('display', 'inline')
		$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility')
		$('#assignedFacilityContainer .required').css('display', 'none')
		
		
		$('#assignedVendorIdSelect').css('display', 'inline')
		$('#assignedVendorIdSelect').attr('alt', 'Assigned Vendor')
		$('#vendor .required').css('display', 'none')
		
	}
	else if(hasPermission("National Administrator") || 
		hasPermission("Application Administrator") || 
		hasPermission("Management") || 
		hasPermission("NAC_POC") ||
		hasPermission("Vendor") ||		
		hasPermission("OTS Contract Manager") || 
		hasPermission("Reports Only")) {
		
		if(!hasPermission("VISN Administrator")) {
			
			$('#assignedVisnIdSelect').css('display', 'none')
			$('#assignedVisnIdSelect').val("-1")
			$('#assignedVisnIdSelect').attr('alt', 'Assigned Visn')
			$('#assignedVisnContainer .required').css('display', 'none')
		}
		
		if(!hasPermission("Facility Administrator") && !hasPermission("Care Coordinator") && !hasPermission("QIR Originator") ) {
			
			$('#assignedFacilityIdSelect').css('display', 'none')
			$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility')
			$('#assignedFacilityIdSelect').val("-1")
			$('#assignedFacilityContainer .required').css('display', 'none')			
		 } 

	}
	else {
	
		
		$('#assignedVisnIdSelect').css('display', 'inline')	
		
		$('#assignedFacilityIdSelect').css("display", 'inline')	
		$('#assignedFacilityIdSelect').attr("alt", 'Assigned Facility required field')	
		$('#assignedFacilityContainer .required').css('display', 'inline')
		
		
		$('#assignedVendorIdSelect').css('display', 'none')
		$('#assignedVendorIdSelect').val("-1")
		$('#assignedVendorIdSelect').attr('alt', 'Assigned Vendor')
		$('#vendor .required').css('display', 'none')
		
	}
	
	if (hasPermission("Vendor")) {
		$('#vendor').css('display', 'inline')
		
		$('#assignedVendorIdSelect').css('display', 'inline')		
		$('#assignedVendorIdSelect').attr('alt', 'Assigned Vendor required field')		
		$('#vendor .required').css('display', 'inline')
	}else {			
		
		$('#assignedVendorIdSelect').css('display', 'none')
		$('#assignedVendorIdSelect').val("-1")
		$('#vendor').css("display", 'none')
		$('#vendor .required').css('display', 'none')			
	}
		
	if (hasPermission("VISN Administrator")) {		
		
		$('#assignedVisnIdSelect').css('display', 'inline')
		$('#assignedVisnIdSelect').attr('alt', 'Assigned Visn required field')
		$('#assignedVisnContainer .required').css('display', 'inline')
		
		if(!hasPermission("Facility Administrator")) {
			
			$('#assignedFacilityIdSelect').css('display', 'inline')
			$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility')
			$('#assignedFacilityContainer .required').css('display', 'none')
		}
		
		if(hasPermission("QIR Originator")) {
			
			$('#assignedFacilityIdSelect').css('display', 'inline')
			$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility required field')
			$('#assignedFacilityContainer .required').css('display', 'inline')
		}
	}
	
	if (hasPermission("Facility Administrator")) {	

		if(!hasPermission("VISN Administrator")) {
			
			$('#assignedVisnIdSelect').css('display', 'inline')
			$('#assignedVisnIdSelect').attr('alt', 'Assigned VISN')
			$('#assignedVisnContainer .required').css('display', 'none')
		}
				
		$('#assignedFacilityIdSelect').css('display', 'inline')
		$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility required field')
		$('#assignedFacilityContainer .required').css('display', 'inline')
	}
	
	if (hasPermission("Care Coordinator")) {
		
		$('#assignedFacilityIdSelect').css('display', 'inline')
		$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility required field')
		$('#assignedFacilityContainer .required').css('display', 'inline')	

			if(!hasPermission("VISN Administrator")) {				
				$('#assignedVisnContainer .required').attr('alt', 'Assigned VISN')
				$('#assignedVisnContainer .required').css('display', 'none')
			}
	}	
	
	if (hasPermission("Program Support Assistant")) {
		
		$('#assignedFacilityIdSelect').css('display', 'inline')
		$('#assignedFacilityIdSelect').attr('alt', 'Assigned Facility required field')
		$('#assignedFacilityContainer .required').css('display', 'inline')		
	}	
	
	if(hasPermission("QIR Originator")) {
		
		if(!hasPermission("VISN Administrator")) {
			
			$('#assignedVisnIdSelect').css('display', 'inline')
			$('#assignedVisnIdSelect').attr('alt', 'Assigned Visn')
			$('#assignedVisnContainer .required').css('display', 'none')
		}
		
		if(hasPermission("Management") && !hasPermission("VISN Administrator")){
			
			$('#assignedVisnIdSelect').css('display', 'none')
			$('#assignedVisnIdSelect').attr('alt', 'Assigned Visn')
			$('#assignedVisnContainer .required').css('display', 'none')
		}
				
		$('#assignedFacilityIdSelect').css('display', 'inline')
		$('#assignedFacilityIdSelect').attr('alt', 'assigned facility required field')
		$('#assignedFacilityContainer .required').css('display', 'inline')		
	}
}

/**
 * Determine if a role is assigned to the user.
 * @param role
 * @returns {Boolean}
 */
function hasPermission(role) { 
 return selectedRoles.indexOf(role.toString()) > -1;	
}


/**
 * May want to revert back to Spring validator.
 * @returns {Boolean}
 */
function validate() {

	var notDirty = true;
    $('#error').css('display', 'none');
	
	if($('#isCurrentUserAppAdmin').val() == 'true') {
		rolesUpdated()
		return notDirty;
	}
	
	
	if( $('#assignedVisnContainer .required').is(":visible") &&
	$('#assignedVisnIdSelect').val() == "-1") {		
		
		$('#visnRequiredMessage').css('display', 'block');
		notDirty = false;
	
	}
	else {		
		$('#visnRequiredMessage').css('display', 'none');
	}	
	
	if( $('#assignedFacilityContainer .required').is(":visible")  &&
	$('#assignedFacilityIdSelect').val() == "-1" ) {		
		$('#facilityRequiredMessage').css('display', 'block');
		notDirty = false;
	}
	else {
		
		$('#facilityRequiredMessage').css('display', 'none');
	}
	
	
	if( $('#vendor .required').is(":visible")  &&
			$('#assignedVendorIdSelect').val() == "-1" ) {
		
		$('#vendorRequiredMessage').css('display', 'block');
		notDirty = false;		
	}
	else {
		
		$('#vendorRequiredMessage').css('display', 'none');
	}
	
	// Only validate for selected roles if not denying the user.
	if( $("#isDeny").val() == "false" || $("#isDeny").val() == "")
	{	
		if(selectedRoles.length == 0) {
			
			$('#roleRequiredMessage').css('display', 'block');
			notDirty = false;
		}
		else {
			
			$('#roleRequiredMessage').css('display', 'none');
		}
	}
	
	if( $("#isDeny").val() == "true" ) {
	
		var registrationDeniedReason = $("#assignedRegistrationDenied").val();
		
		if(registrationDeniedReason == "-1") {
			$('#registrationDeniedRequiredMessage').css('display', 'block');
			notDirty = false;
		}
		else {
			$('#registrationDeniedRequiredMessage').css('display', 'none');
		}
	}
	

		var regDeniedContainerVisible =  $("#registrationDeniedContainer").is(':visible')
	if(regDeniedContainerVisible == true ) {
		
		// We don't need to enforce that an assigned role is 
	
		if( $("#assignedRegistrationDenied").is(':visible') == "false" ) {
		
			if(selectedRoles.length == 0) {
			
				$('#roleRequiredMessage').css('display', 'block');
				notDirty = false;
			}
			else {			
				$('#roleRequiredMessage').css('display', 'none');
			}

		}
	}
	
	if ( regDeniedContainerVisible == false ) {
	
			if(selectedRoles.length == 0) {
			
				$('#roleRequiredMessage').css('display', 'block');
				notDirty = false;
			}
			else {			
				$('#roleRequiredMessage').css('display', 'none');
			}
	}

	if($('#inactive').is(":checked")) {
		
		
		if($('#inactiveReasonId').val() == "-1") {
			$('#inactivateReasonRequiredMessage').css('display', 'block')
			notDirty = false;
		}
		else {
			$('#inactivateReasonRequiredMessage').css('display', 'none')
			
		}
		var date = $('#datepicker').val()
		
		if( !validateDate(date) ) {
			$('#inactivateDateRequiredMessage').css('display', 'block')
			notDirty = false;
		}
		else {
			$('#inactivateDateRequiredMessage').css('display', 'none')			
		}
		
	}
	else {
		$('#inactivateReasonRequiredMessage').css('display', 'none')
		$('#inactivateDateRequiredMessage').css('display', 'none')
	}
	
	// Check to see if Assigned VISN Matches Assigned Facilities VISN
	if( $('#assignedFacilityContainer').is(":visible") && $('#assignedVisnContainer').is(":visible")  ) {
		
		var assignedVisnId = $('#assignedVisnId').val()
		var assignedFacilitiesVisnId = $('#assignedFacilitiesVisnId').val()
		
		var assignedVisn = $('#assignedVisnIdSelect').val()
		var assignedFacilityText = $('#assignedFacilityIdSelect option:selected').text()
		var assignedFacilityVal = $('#assignedFacilityIdSelect option:selected').val()
		var isVisnRequired = $('#assignedVisnContainer .required').is(":visible")
		var isFacilityRequired = $('#assignedFacilityContainer .required').is(":visible")
		var index = assignedFacilityText.indexOf(assignedVisn)
	
		
		if(isVisnRequired && assignedVisn == "-1") {		
			
				$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'block')
				notDirty = false;
		} 
		else {
			$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'none')
		}
		
		
		if(isFacilityRequired && assignedFacilityVal == "-1") {
			
				$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'block')
				notDirty == false;
		}
		else {
			$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'none')
		}
		
		if(assignedVisn != "-1" && assignedFacilityVal != "-1")	{	
			if(index == -1 ) {
				$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'block')
				notDirty = false;
			}
		}
		else {
			$('#assignedVisnMustMatchAssignedFacilityVisnMessage').css('display', 'none')
		}

	}
	
	showErrors(notDirty)
	return notDirty;
}

function showErrors(notDirty) {

	if(notDirty == false) {
		$('#error').css('display', 'inline');
		forceFocusOnInfoMessage()
	}
	rolesUpdated()
}

function forceFocusOnInfoMessage() {

	if($('#error').is(':visible')){	
		$('#error h4:first').focus()	
	}

}

function confirmCancel() {
	confirmDialog("All unsaved data will be lost. Do you still want to cancel?", function() {
		document.location.href = $('#returnPage').val();
	},{
		okButtonLabel : 'Yes',
		cancelButtonLabel : 'No'
	})
}
