var attentionDialogInitialized = false

/**
 *  Displays Attention Dialog 
 */
function displayAttentionDialog(messageToDisplay, detailsHtml, title) {
	initializeAttentionDialog(function() {
		$("#attentionDialogMessage").empty().html(messageToDisplay)
		
		var hasDetails = (detailsHtml != null && typeof(detailsHtml) != "undefined" && detailsHtml != '')
		$("#attentionDialogDetailsDiv").empty()
		if (hasDetails)
			$("#attentionDialogDetailsDiv").html(detailsHtml)
		$("#attentionDialogDetailsRow").toggle(hasDetails)
		
		$('#attentionDialog').dialog('option', 'title', title ? escapeHTML(title) : 'Attention')
		$("#attentionDialog").dialog("open")
	})
	
	if ($("#attentionDialogDetailsDiv").is(":visible")) {
		attentionDialogOpenDetailsFunction()
	} else {
		attentionDialogCloseDetailsFunction()
	}
}

function displayAttentionDialogForValidationFailure(message, rule, recommendation) {
	var hasRule = (typeof(rule) != "undefined" && rule != '')
	var hasRecommendation = (typeof(recommendation) != "undefined" && recommendation != '')
	var hasEither = hasRule || hasRecommendation
	
	var html = null
	if (hasEither) {	
		html = '<table cellpadding="5">'
		if (hasRule) {
			html += '<tr valign="top">'
				+ '		<td align="right"><b>Rule:</b></td>'
				+ '		<td>' + rule + '</td>'
				+ '	</tr>'
		}
		if (hasRecommendation) {		
			html += '<tr valign="top">'
				+ '		<td align="right"><b>Recommendation:</b></td>'
				+ '		<td>' + recommendation + '</td>'
				+ '	</tr>'
		}
		html += '</table>'
	}
	displayAttentionDialog(message, html, 'Validation Error')
}

function attentionDialogOpenDetailsFunction() {
	$("#attentionDialogCopyDetailsButton").show()
	$("#attentionDialog").dialog("option", "height", '600');
}

function attentionDialogCloseDetailsFunction() {
	$("#attentionDialogCopyDetailsButton").hide()
	$("#attentionDialog").dialog("option", "height", '300');
}

function initializeAttentionDialog(callback) {
	if (attentionDialogInitialized) {
		callback()
		return
	}
	
	$('#attentionDialogDetailsLink').expandPanel({
		speed : 500,
		easing : '',
		changeText : 0,
		title : 'Details',
		open : attentionDialogOpenDetailsFunction,
		close : attentionDialogCloseDetailsFunction
	})
		
	$("#attentionDialog").dialog({
		autoOpen: false,
		modal: true,
		// show: 'slide',
		draggable: true,
		resizable:true,
		width: 650,
		height: 300,
		buttons: {
			'Copy Details' : {
				text : 'Copy Details',
				id : 'attentionDialogCopyDetailsButton',
				click : function() {
					copyContainerText('attentionDialogDetailsDiv')
					alert('The details were copied to the clipboard.')
				}
			},
			Close: function() {
				$(this).dialog('close')
			}
		},
		create: function() {
			callback()
		}
	})
	
	attentionDialogInitialized = true
}



