﻿function generateInteraction() {
    // Create new HB Interaction

    // validate the Phone Call's required fields
    var type = Xrm.Page.getAttribute("vhacrm_type_code").getValue();
    var subject = Xrm.Page.getAttribute("subject").getValue();
    var callTo = Xrm.Page.getAttribute("to").getValue();
    var facility = Xrm.Page.getAttribute("vhacrm_facilityid").getValue();

    if (subject == "") {
        subject = null;
    }

    if (type != null && subject != null && callTo != null && facility != null) {

        Xrm.Page.ui.clearFormNotification('GenInteractionReqFields');

        var interactionObj = new Object();
        interactionObj.vhacrm_lobid = { Id: '{C8E34764-BFBB-E511-9414-0050568DC724}', LogicalName: "vhacrm_lob", Name: "vhacrm_lobid" };
        interactionObj.bah_facilityid = { Id: facility[0].id, LogicalName: "bah_facility", Name: facility[0].name };
        interactionObj.bah_veteranid = { Id: callTo[0].id, LogicalName: "contact", Name: callTo[0].name };

        var jsonEntity = window.JSON.stringify(interactionObj);
        var entityCollection = "bah_interactionsSet";
        var context = Xrm.Page.context;
        var serverUrl = context.getClientUrl();
        var oDataEndPoint = '/XRMServices/2011/OrganizationData.svc';
        var odataUri = serverUrl + oDataEndPoint + "/" + entityCollection;

        $.ajax({
            type: "POST",
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: odataUri,
            data: jsonEntity,
            async: true,
            beforeSend: function (XMLHttpRequest) {
                XMLHttpRequest.setRequestHeader("Accept", "application/json");
            },
            success: function (data, textStatus, XmlHttpRequest) {
                // Commented out on 2/1 - cannot update closed activities

                /*
                // Update Phonecall with new Interaction
                var newInteraction = new Array();
                newInteraction[0] = new Object();
                newInteraction[0].id = data.d.bah_interactionsId;
                newInteraction[0].name = data.d.bah_name;
                newInteraction[0].entityType = "bah_interactions";

                //Xrm.Page.getAttribute("vhacrm_interactionsid").setValue(newInteraction);
                
                */

                // Open new Interaction form
                Xrm.Utility.openEntityForm("bah_interactions", data.d.bah_interactionsId, null);
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) {
                alert('Fail: Ajax Error in generateInteraction: ' + errorThrown);
            }
        });
    }
    else {
        Xrm.Page.ui.setFormNotification("Please fill in all required fields before generating an interaction.", "ERROR", 'GenInteractionReqFields');
    }
}

function enableGenerateInteractionButton() {
    // Check for HRC Outbound form
    var hrcFormId = "25b9d714-badd-47d5-8b6f-30612a2bcba2";
    var currentFormId = Xrm.Page.ui.formSelector.getCurrentItem().getId();

    var enableButton = true;

    if (currentFormId != hrcFormId) {
        enableButton = false;
    }

    // Check for completed phone call record

    var status = Xrm.Page.getAttribute("statecode").getValue();

    if (status != 1) {
        enableButton = false;
    }

    return enableButton;

}

function enableAddButton() {
    var enableButton = true;
    var currentUserRoles = Xrm.Page.context.getUserRoles();
    for (var i = 0; i < currentUserRoles.length; i++) {
        var userRoleId = currentUserRoles[i];
        var userRoleName = GetRoleName(userRoleId);
        if (userRoleName == "HRC - HD Tier 3") {
            enableButton = false;
        }
    }
    return enableButton;
}

//Get Rolename based on RoleId
function GetRoleName(roleId) {
    //var serverUrl = Xrm.Page.context.getServerUrl();
    var serverUrl = location.protocol + "//" + location.host + "/" + Xrm.Page.context.getOrgUniqueName();
    var odataSelect = serverUrl + "/XRMServices/2011/OrganizationData.svc" + "/" + "RoleSet?$filter=RoleId eq guid'" + roleId + "'";
    var roleName = null;
    $.ajax(
        {
            type: "GET",
            async: false,
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: odataSelect,
            beforeSend: function (XMLHttpRequest) { XMLHttpRequest.setRequestHeader("Accept", "application/json"); },
            success: function (data, textStatus, XmlHttpRequest) {
                roleName = data.d.results[0].Name;
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) { alert('OData Select Failed: ' + textStatus + errorThrown + odataSelect); }
        }
    );
    return roleName;
}


