function form_OnLoad() {
    if (Xrm.Page.ui.getFormType() != 1) { loadTypeForm(); }
    if (Xrm.Page.ui.getFormType() != 1 && Xrm.Page.getAttribute("vhacrm_veteranid").getValue()) { loadWebParts(); }

    if (Xrm.Page.ui.getFormType() == 4) {
        Xrm.Page.getControl("WebResource_Complete").setVisible(false);
        
        
    }
}

function form_OnSave(context) {
    preventAutoSave(context);
}

function loadWebParts() {
    unattendedSearchFromRelatedRecord("vhacrm_veteranid", loadAssociations, loadESRWebParts);
    
}

function loadAssociations(icn) {
    displayWebPart(icn, 'IFRAME_associations', 'esr_associations_endpoint');
}

function loadESRWebParts(icn) {
    //pass icn, folder path and list of control names/resource names to the loadEsrResources function
    loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_enrollment|enrollment.htm,WebResource_esreligibility|eligibility.htm,WebResource_demographics|demographics.htm');
}

function loadEsrResources(icn, resourcepath, resourceparam) {
    SDK.REST.retrieveMultipleRecords("bah_keyvaluepair",
		"$select=*&$filter=bah_name_text eq 'esr_endpoint'",
		function (data) {
		    if (data.length > 0) {
		        //figure out the full url to the BAH esr proxy
		        var esrEndpoint = data[0].bah_stringvalue_text;
		        var actualEndpoint = esrEndpoint.replace('{0}', '000000' + icn + '000000'); //pad ICN with six zeroes on beginning and end

		        //build the querystring to call the page that will query esr and display the data - note CRM requires everything be encoded and passed in a 'data' parameter
		        var qs = 'data=' + encodeURIComponent('esr=' + encodeURIComponent(actualEndpoint));

		        var resourcearr = resourceparam.split(',');

		        if (resourcearr.length > 0) {
		            for (var i = 0; i < resourcearr.length; i++) {
		                try {
		                    //start with assumption that resource name and control name are the same
		                    var controlname = "";
		                    var webresourcename = "";

		                    //check to see if we have pipe-separated value -> control name should be first, resource name should be second
		                    if (resourcearr[i].indexOf('|') > 0) {
		                        controlname = resourcearr[i].split('|')[0];
		                        webresourcename = resourcearr[i].split('|')[1];
		                    }
		                    else {
		                        throw ("ESR resource target control and resource name not supplied in correct format.")
		                    }

		                    //get a reference to the iframe
		                    var webresource = Xrm.Page.ui.controls.get(controlname);
		                    if (webresource == null) {
		                        throw ("Could not find ESR resource target control with name - '" + controlname + "'");
		                    }

		                    //set the iframe's url
		                    var webresourceUrl = Xrm.Page.context.getClientUrl() + resourcepath + '/' + webresourcename + '?' + qs;
		                    webresource.setSrc(webresourceUrl);
		                }
		                catch (err) { alert(err); }
		            }
		        }
		    }
		},
		function (error) {
		    //do nothing
		},
		function () {
		    //do nothing on completion
		}
	);
}
