var _intervalVar = null;

function form_OnLoad() {
    if (Xrm.Page.ui.getFormType() != 1) { loadLOBForm(); }

    if (Xrm.Page.getAttribute("vhacrm_isassist_bool") != null) {
        Xrm.Page.getAttribute("vhacrm_isassist_bool").setSubmitMode("never");
    }

    if (Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text") != null) {
        Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text").setSubmitMode("always");
    }

    if (Xrm.Page.ui.getFormType() == 4) {
        Xrm.Page.getControl("WebResource_CompleteInteraction").setVisible(false);
        Xrm.Page.getControl("WebResource_completecasenote").setVisible(false);
        Xrm.Page.getControl("WebResource_mvisearch").setVisible(false);
    
    }

    //show and hide sections 
    checkResolution();

    //check for subareas and templates asynchronously
    checkSubareas();

    //load ESR, VISTA web parts
    loadWebParts();

    //pre-filter the Pharmacy lookup based on facility
    preFilterLookup();
}

function form_OnSave(context) {
    preventAutoSave(context);

    //show and hide sections according to type
    checkResolution();
}

function firstname_OnChange() { refresh.firstname_OnChange(); }

function lastname_OnChange() { refresh.lastname_OnChange(); }

function dob_OnChange() { refresh.dob_OnChange(); }

function ssn_OnChange() { refresh.ssn_OnChange(); }

function edipi_OnChange() { refresh.edipi_OnChange(); }

function gender_OnChange() { refresh.gender_OnChange(); }

function daytimePhone_OnChange() { refresh.daytimePhone_OnChange(); }

function preFilterLookup() {

    Xrm.Page.getControl("vhacrm_facilitypharmacyid").removePreSearch();
    Xrm.Page.getControl("vhacrm_facilitypharmacyid").addPreSearch(function () {
        addLookupFilter();
    });

}

function addLookupFilter() {
    var facilityId = Xrm.Page.getAttribute("bah_facilityid").getValue();
    if (facilityId != null) {

        fetchXml = "<filter type='and'><condition attribute='vhacrm_facilitycategory_code' operator='eq' value='713770000' /><condition attribute='bah_facilityid' operator='eq' uiname='" + facilityId[0].name + "' uitype='bah_facility' value='" + facilityId[0].id + "' /></filter>";

        Xrm.Page.getControl("vhacrm_facilitypharmacyid").addCustomFilter(fetchXml);
    }
}

function facility_OnChange() {
    // Clear Pharmacy lookup
    Xrm.Page.getAttribute("vhacrm_facilitypharmacyid").setValue(null);
    // Save, required for Facility extension list (quick view form)
    Xrm.Page.data.save().then(setupFacilityPharmacy(), function (err) { alert(err); }); 
}

function setupFacilityPharmacy() {
    // Filter Pharmacy lookup based on selected Facility
    preFilterLookup();

    //Check to see if if the facility only has a single Facility Detail record with category = Pharmacy.
    var facilityId = Xrm.Page.getAttribute("bah_facilityid").getValue();
    if (facilityId) {
        var oDataSetName = "bah_facilitydetail";
        var filter = "bah_facilityid/Id eq (guid'" + facilityId[0].id.toString() + "') and vhacrm_facilitycategory_code/Value eq 713770000 and statecode/Value eq 0";
        var columns = "*";
        var querystring = "$select=" + columns + "&$filter=" + filter;
        SDK.REST.retrieveMultipleRecords(
			oDataSetName,
			querystring,
			function (data) {
			    if (data.length > 0) {
			        if (data.length == 1) {

			            var lookupReference = [];
			            lookupReference[0] = {};
			            lookupReference[0].id = data[0].bah_facilitydetailId;
			            lookupReference[0].entityType = 'bah_facilitydetail';
			            lookupReference[0].name = data[0].bah_facilitydetailname;

			            Xrm.Page.getAttribute("vhacrm_facilitypharmacyid").setValue(lookupReference);

			        }
			    }
			    else {
			        //nothing yet
			    }
			},
			function (error) {
			    //do nothing
			    alert(error);
			},
			function () {
			    //do nothing on completion
			}
		);
    }
    else {
        //Because there is no Facility, remove the Pharmacy
        Xrm.Page.getAttribute("vhacrm_facilitypharmacyid").setValue(null);
    }
}
function type_OnChange(context) {
    Xrm.Page.getAttribute("vhacrm_areaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_assist_casenotetemplateid").setValue(null);
    N52.Clientside.ExecuteFormulas(context, 'yR9');
}

function area_OnChange(context) {
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setRequiredLevel("none");

    checkSubareas();
    checkTemplates();
}

function resolution_OnChange(context) {
    // Clear Resolution lookup
    Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    Xrm.Page.data.save().then(checkResolution(), function (err) { alert(err); });
}

function checkVeteran() {
    if (Xrm.Page.getAttribute("bah_veteranid").getValue()) {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_History").setDisplayState("expanded");
        Xrm.Page.ui.tabs.get("tab_veteransearch").setDisplayState("collapsed");
    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_History").setDisplayState("collapsed");
    }
}

function checkResolution() {
    if (Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").getValue()) {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(true);
    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(false);
    }
}




function caseNoteTemplate_OnChange(context) {
    appendTemplateText();
}

function loadWebParts() {
    unattendedSearchFromRelatedRecord("bah_veteranid", loadAssociations, loadESRWebParts);
    checkVeteran();
}

function loadAssociations(icn) {
    displayWebPart(icn, 'IFRAME_associations', 'esr_associations_endpoint');
}

function loadESRWebParts(icn) {
    //pass icn, folder path and list of control names/resource names to the loadEsrResources function
    loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_demographics|demographics.htm');
}
// If there is only one Sub Area, make it the default
function checkSubareas() {
    var areaintersectionid = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();
    if (areaintersectionid) {
        var oDataSetName = "vhacrm_subareaintersection";
        var filter = "vhacrm_areaintersectionid/Id eq (guid'" + areaintersectionid[0].id.toString() + "') and statecode/Value eq 0";
        var columns = "*";
        var querystring = "$select=" + columns + "&$filter=" + filter;
        SDK.REST.retrieveMultipleRecords(
			oDataSetName,
			querystring,
			function (data) {
			    if (data.length > 0) {
			        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('required');
			    }
			    else {
			        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('none');
			    }
			},
			function (error) {
			    alert(error);
			    //do nothing
			},
			function () {
			    //do nothing on completion
			}
		);
    }
}

function appendTemplateText() {
    var templateid = Xrm.Page.getAttribute("vhacrm_casenotetemplateid").getValue();
    var existingcasenotetext = Xrm.Page.getAttribute("vhacrm_casenotes_memo").getValue();

    if (templateid) {
        SDK.REST.retrieveRecord(
			templateid[0].id.toString(),
			"vhacrm_casenotetemplate",
			"vhacrm_template_memo",
			null,
			function (data) {
			    var casenotetext = data.vhacrm_template_memo;
			    if (casenotetext) {
			        if (existingcasenotetext) {
			            casenotetext = existingcasenotetext + "\r\n------------\r\n" + casenotetext;
			        }
			        Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
			    }
			    Xrm.Page.getAttribute("vhacrm_temp_text").setValue(null);
			},
			function (error) {
			    //do nothing
			    alert(error);
			}
		);
    }
}
