function form_OnLoad(context) {

    // Show appropriate form content according to Type (Email or Default)
    var ctype = Xrm.Page.getAttribute("vhacrm_correspondencetype_code");

    if (ctype) {
        if (ctype.getValue() == 713770001) {
            // Show email content & hide address info
            Xrm.Page.ui.tabs.get("general").sections.get("section_selectedaddress_lookup").setVisible(false);
            Xrm.Page.ui.tabs.get("general").sections.get("section_selectedaddress_text").setVisible(false);
            Xrm.Page.ui.tabs.get("general").sections.get("section_newaddress").setVisible(false);
            Xrm.Page.ui.tabs.get("tab_addresses").setVisible(false);
            Xrm.Page.ui.tabs.get("tab_instructions").setVisible(false);
        }
        else {
            // Show default content
            Xrm.Page.ui.tabs.get("general").sections.get("section_selectedaddress_lookup").setVisible(true);
            Xrm.Page.ui.tabs.get("general").sections.get("section_newaddress").setVisible(true);
            Xrm.Page.ui.tabs.get("tab_addresses").setVisible(true);
            Xrm.Page.ui.tabs.get("tab_instructions").setVisible(true);

            // Exclude Email from Correspondence Type optionset
            if (CheckUserRole() == false) {
                setupTypeOptionSet();

            }

            // Display Address Section
            N52.Clientside.ExecuteFormulas(context, 'HYy');
        }

        Xrm.Page.getControl("vhacrm_correspondencetemplateid").addPreSearch(function () {
            addLookupFilter();
        });
    }

}


function reApplyFilter() {
    var functionName = "reApplyFilter";
    Xrm.Page.getAttribute("vhacrm_correspondencetemplateid").setValue(null);
    try {
        objoptionset = Xrm.Page.getAttribute("vhacrm_correspondencetype_code").getSelectedOption();
        if (objoptionset != null) {
            Xrm.Page.getControl("vhacrm_correspondencetemplateid").removePreSearch(function () {
                addLookupFilter();
            });
            Xrm.Page.getControl("vhacrm_correspondencetemplateid").addPreSearch(function () {
                addLookupFilter();
            });
        }
    }
    catch (e) {
        throwError(functionName, e.message);
    }
}

function addLookupFilter() {
    var ctype = Xrm.Page.getAttribute("vhacrm_correspondencetype_code").getValue();
    if (ctype != null) {
        fetchXml = "<filter type='and'><condition attribute='vhacrm_correspondencetype_code' operator='eq' value='" + ctype + "' /></filter>"; Xrm.Page.getControl("vhacrm_correspondencetemplateid").addCustomFilter(fetchXml);
    }
}

function setupTypeOptionSet() {
    var optEmailValue = 713770001;
    var pickList = Xrm.Page.getControl("vhacrm_correspondencetype_code");

    if (pickList != null) {
        // Remove Email option from optionset
        pickList.removeOption(optEmailValue);
    }
}

//Check login User has 'System Administrator' role
function CheckUserRole() {
    var currentUserRoles = Xrm.Page.context.getUserRoles();
    for (var i = 0; i < currentUserRoles.length; i++) {
        var userRoleId = currentUserRoles[i];
        var userRoleName = GetRoleName(userRoleId);
        if (userRoleName == "System Administrator" || userRoleName == "HRC - Admin") {
            return true;
        }
    }
    return false;
}

//Get Rolename based on RoleId
function GetRoleName(roleId) {
    //var serverUrl = Xrm.Page.context.getServerUrl();
    var serverUrl = location.protocol + "//" + location.host + "/" + Xrm.Page.context.getOrgUniqueName();
    var odataSelect = serverUrl + "/XRMServices/2011/OrganizationData.svc" + "/" + "RoleSet?$filter=RoleId eq guid'" + roleId + "'";
    var roleName = null;
    $.ajax(
        {
            type: "GET",
            async: false,
            contentType: "application/json; charset=utf-8",
            datatype: "json",
            url: odataSelect,
            beforeSend: function (XMLHttpRequest) { XMLHttpRequest.setRequestHeader("Accept", "application/json"); },
            success: function (data, textStatus, XmlHttpRequest) {
                roleName = data.d.results[0].Name;
            },
            error: function (XmlHttpRequest, textStatus, errorThrown) { alert('OData Select Failed: ' + textStatus + errorThrown + odataSelect); }
        }
    );
    return roleName;
}