var _intervalVar = null;

function form_OnLoad() {
    if (Xrm.Page.ui.getFormType() != 1) { loadLOBForm(); }

    if (Xrm.Page.getAttribute("vhacrm_isassist_bool") != null) {
        Xrm.Page.getAttribute("vhacrm_isassist_bool").setSubmitMode("never");
    }

    if (Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text") != null) {
        Xrm.Page.getAttribute("vhacrm_dayssincelastcontact_text").setSubmitMode("always");
    }
	
	if(Xrm.Page.ui.getFormType() == 4){
		Xrm.Page.getControl("WebResource_CompleteInteraction").setVisible(false);
		Xrm.Page.getControl("WebResource_completecasenote").setVisible(false);
		Xrm.Page.getControl("WebResource_mvisearch").setVisible(false);
	}
	else {
	    if (Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue() && Xrm.Page.getAttribute("bah_veteranid").getValue()) {
	        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(true);
	    }
	    else {
	        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(false);
	    }
	}

    //show/hide sections and tabs
	checkType();
	checkResolution();

    //check for subareas and templates asynchronously
	checkSubareas(false);
	checkTemplates(false);

    //load ESR, VISTA web parts
	loadWebParts();
	

}

function firstname_OnChange() { refresh.firstname_OnChange(); }

function lastname_OnChange() { refresh.lastname_OnChange(); }

function dob_OnChange() { refresh.dob_OnChange(); }

function ssn_OnChange() { refresh.ssn_OnChange(); }

function edipi_OnChange() { refresh.edipi_OnChange(); }

function gender_OnChange() { refresh.gender_OnChange(); }

function daytimePhone_OnChange() { refresh.daytimePhone_OnChange(); }



function type_OnChange(context) {
    Xrm.Page.getAttribute("vhacrm_areaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setRequiredLevel("none");
    Xrm.Page.getAttribute("vhacrm_assist_casenotetemplateid").setValue(null);
    N52.Clientside.ExecuteFormulas(context, 'yDn');
}

function checkType() {
    //check for Disaster
    var typeValue = Xrm.Page.getAttribute("vhacrm_typeintersectionid").getValue();
    if (typeValue) {
        if (typeValue[0].name == "Disaster") {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_disaster").setVisible(true);
        }
        else {
            Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_disaster").setVisible(false);
        }
    }
}

function checkVeteran() {
	//var casehistory = Xrm.Page.getControl("VeteranCaseNoteHistory_VeteranCaseNoteHistory_contact_VeteranCaseNotes");
	//if(!!casehistory && casehistory.getControlType() == "subgrid") casehistory.refresh();
	//Xrm.Page.ui.tabs.get("tab_History").setDisplayState("collapsed");
    if (Xrm.Page.getAttribute("bah_veteranid").getValue()) {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(false);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_correspondencebutton").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_veteransearch").setDisplayState("collapsed");
    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo_input").setVisible(true);
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_veteraninfo").setVisible(false);
        if (Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue()) {
            Xrm.Page.ui.tabs.get("tab_veteransearch").setDisplayState("expanded");
        }
       
    }
}

function area_OnChange(context) {
    Xrm.Page.data.save().then(area_Callback(), function (err) { alert(err); });
}
function area_Callback() {
    checkSubareas(false);
    checkTemplates(false);
    Xrm.Page.getAttribute("vhacrm_subareaintersectionid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(null);
    Xrm.Page.getAttribute("vhacrm_assist_casenotetemplateid").setValue(null);
}

function callbackPhone_OnChange(context) {
    Xrm.Page.getControl("vhacrm_callbacknumber_text").clearNotification();
    var callbackPhone = Xrm.Page.getAttribute("vhacrm_callbacknumber_text").getValue();
    if (callbackPhone) {
        //normalize string and remove all unnecessary characters
        var cleanedPhoneNumber = callbackPhone.replace(/[^\d]/g, "");
        //check if number length equals to 10
        if (cleanedPhoneNumber.length == 10) {
            //reformat phone number
            Xrm.Page.getAttribute("vhacrm_callbacknumber_text").setValue(cleanedPhoneNumber.replace(/(\d{3})(\d{3})(\d{4})/, "($1)$2-$3"));
        }
        else {
            Xrm.Page.getControl("vhacrm_callbacknumber_text").setNotification("Please enter a phone number of at least 10 digits");
        }
    }
}

function resolution_OnChange(context) {
    checkResolution();
}

function checkResolution() {
    if (Xrm.Page.getAttribute("vhacrm_resolutionintersectionid").getValue()) {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(true);
    }
    else {
        Xrm.Page.ui.tabs.get("tab_interactioninformation").sections.get("section_complete").setVisible(false);
    }
}

function caseNoteTemplate_OnChange(context) {
    Xrm.Page.data.entity.save();
    _intervalVar = setInterval(function () { if (!Xrm.Page.data.entity.getIsDirty()) { refreshCallbackCaseNoteTemplate(context); } }, 100);
}
function refreshCallbackCaseNoteTemplate(context) {
    clearInterval(_intervalVar);
    N52.Clientside.ExecuteFormulas(context, 'GV7');
}

function loadWebParts() {
    unattendedSearchFromRelatedRecord("bah_veteranid", loadAssociations, loadESRWebParts);
    checkVeteran();
}

function loadAssociations(icn) {
    displayWebPart(icn, 'IFRAME_associations', 'esr_associations_endpoint');
}

function loadESRWebParts(icn) {
    //pass icn, folder path and list of control names/resource names to the loadEsrResources function
    loadEsrResources(icn, '/webresources/vhacrm_/ESRParts', 'WebResource_enrollment|enrollment.htm,WebResource_esreligibility|eligibility.htm,WebResource_demographics|demographics.htm');
}

function checkSubareas(sync) {
    //var interactionno = Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue();
    var areaintersectionid = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();

    if (areaintersectionid) {
        var oDataSetName = "vhacrm_subareaintersection";
        var filter = "vhacrm_areaintersectionid/Id eq (guid'" + areaintersectionid[0].id.toString() + "') and statecode/Value eq 0";
        var columns = "*";

        if (sync) {
            var data = retrieveMultipleSync(oDataSetName, columns, filter);
            if (data != null) {
                if (data.length > 0) {
                    Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('required');
                }
                else {
                    Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('none');
                }
            }
        }
        else {
            var querystring = "$select=" + columns + "&$filter=" + filter;
            SDK.REST.retrieveMultipleRecords(
				oDataSetName,
				querystring,
				function (data) {
				    if (data.length > 0) {
				        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('required');
				    }
				    else {
				        Xrm.Page.getAttribute('vhacrm_subareaintersectionid').setRequiredLevel('none');
				    }
				},
				function (error) {
				    alert(error);
				    //do nothing
				},
				function () {
				    //do nothing on completion
				}
			);
        }
    }
}

function checkTemplates(sync) {
    //var interactionno = Xrm.Page.getAttribute("vhacrm_interactionno_text").getValue();
    var areaintersectionid = Xrm.Page.getAttribute("vhacrm_areaintersectionid").getValue();

    if (areaintersectionid) {
        var oDataSetName = "vhacrm_casenotetemplate";
        var filter = "vhacrm_areaintersectionid/Id eq (guid'" + areaintersectionid[0].id.toString() + "') and statecode/Value eq 0";
        var columns = "*";
        if (sync) {
            var data = retrieveMultipleSync(oDataSetName, columns, filter);

            if (data != null) {
                if (data.length > 0) {
                    Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('required');
                    if (data.length == 1) {
                        var lookupReference = [];
                        lookupReference[0] = {};
                        lookupReference[0].id = data[0].vhacrm_casenotetemplateId;
                        lookupReference[0].entityType = 'vhacrm_casenotetemplate';
                        lookupReference[0].name = data[0].vhacrm_name;

                        Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(lookupReference);

                        var casenotetext = data[0].vhacrm_template_memo;
                        var existingcasenotetext = Xrm.Page.getAttribute("vhacrm_casenotes_memo").getValue();
                        if (casenotetext) {
                            if (existingcasenotetext) {
                                casenotetext = existingcasenotetext.concat("\n", "------------", "\n", casenotetext);
                                Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
                            }
                            else {
                                Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
                            }
                        }
                    }
                    Xrm.Page.getAttribute("vhacrm_temp_text").setValue(null);
                }
                else {
                    Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('none');
                    Xrm.Page.getAttribute('vhacrm_casenotes_memo').setRequiredLevel('none');
                }
            }
        }
        else {
            var querystring = "$select=" + columns + "&$filter=" + filter;
            SDK.REST.retrieveMultipleRecords(
				oDataSetName,
				querystring,
				function (data) {
				    if (data.length > 0) {
				        Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('required');
				        if (data.length == 1) {
				            var lookupReference = [];
				            lookupReference[0] = {};
				            lookupReference[0].id = data[0].vhacrm_casenotetemplateId;
				            lookupReference[0].entityType = 'vhacrm_casenotetemplate';
				            lookupReference[0].name = data[0].vhacrm_name;

				            Xrm.Page.getAttribute("vhacrm_casenotetemplateid").setValue(lookupReference);

				            var casenotetext = data[0].vhacrm_template_memo;
				            var existingcasenotetext = Xrm.Page.getAttribute("vhacrm_casenotes_memo").getValue();
				            if (casenotetext) {
				                if (existingcasenotetext) {
				                    casenotetext = existingcasenotetext.concat("\n", "------------", "\n", casenotetext);
				                    Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
				                }
				                else {
				                    Xrm.Page.getAttribute("vhacrm_casenotes_memo").setValue(casenotetext);
				                }
				            }
				        }
				        Xrm.Page.getAttribute("vhacrm_temp_text").setValue(null);
				    }
				    else {
				        Xrm.Page.getAttribute('vhacrm_casenotetemplateid').setRequiredLevel('none');
				        Xrm.Page.getAttribute('vhacrm_casenotes_memo').setRequiredLevel('none');
				    }
				},
				function (error) {
				    //do nothing
				    alert(error);
				},
				function () {
				    //do nothing on completion
				}
			);
        }
    }
}

function retrieveMultipleSync(odataSetName, select, filter) {
    // Get Server URL
    var serverUrl = "";
    if (Xrm.Page.context.getClientUrl) {
        //Post UR 12
        serverUrl = Xrm.Page.context.getClientUrl();
    }
    else {
        //Pre UR 12
        serverUrl = Xrm.Page.context.getServerUrl();
    }
    var ODATA_ENDPOINT = "/XRMServices/2011/OrganizationData.svc";
    var odataUri = serverUrl + ODATA_ENDPOINT + "/" + odataSetName + 'Set' + "?";
    if (select) {
        odataUri += "$select=" + select;
    }
    if (filter) {
        odataUri += "&" + "$filter=" + filter;
    }
    var service = getRequestObject();
    if (service != null) {
        service.open("GET", odataUri, false);
        service.setRequestHeader("X-Requested-Width", "XMLHttpRequest");
        service.setRequestHeader("Accept", "application/json,text/javascript, */*");
        service.send(null);
        var requestResults = eval('(' + service.responseText + ')').d;
        return requestResults;
    }
}

function getRequestObject() {
    if (window.XMLHttpRequest) {
        return new window.XMLHttpRequest;
    }
    else {
        try {
            return new ActiveXObject("MSXML2.XMLHTTP.3.0");
        }
        catch (ex) {
            return null;
        }
    }
}