# Filename: build-solutionfromsource.ps1
param(
  [Parameter(Mandatory=$True)]
  [string]$SolutionName,
  [switch]$checkout, #Optional  pass if you want to Check Out the existing files in the extract location
  [string]$VersionSpec = "T"
) 
$script_path = $myinvocation.mycommand.path
$script_folder = Split-Path $script_path -Parent
$project_path = Split-Path $script_folder -Parent
$solutionFilesFolder = Join-Path $project_path "source"
$deploy_path = Join-Path $project_path "deploy"
$log_path = Join-Path $project_path "logs"

$transcriptfile = "$log_path/build-solution-transcript-$(get-date -f yyyyMMdd-HHmmss).log"
$logfile = "$log_path/build-solution-sp_log$(get-date -f yyyyMMdd-HHmmss).log"

$ErrorActionPreference="SilentlyContinue"
Stop-Transcript | out-null
$ErrorActionPreference = "Stop"
Start-Transcript -path "$transcriptfile" -append

# TF.exe location
$tfCommand = "C:\Program Files (x86)\Microsoft Visual Studio 11.0\Common7\IDE\tf.exe"

# SolutionPackager location
$solutionPackager = Join-Path $project_path "tools/solutionpackager.exe"

Write-Host "TF.exe: $tfCommand"
Write-Host "SolutionPackager: $solutionPackager"
Write-Host "Solution Files Folder: $solutionFilesFolder"

if ($checkout)
{
  $tfoutput = & "$tfCommand" get $solutionFilesFolder /force /recursive /version:$VersionSpec
}

$packOuput = & "$solutionPackager" /action:pack /zipfile:"$deploy_path\$solutionName.zip" /folder:"$solutionFilesFolder" /errorlevel:Info /log:$logfile

Stop-Transcript
