package gov.va.genisis2;

import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;

/**
 * 
 * @author PII
 *
 */
public class FusekiClient {
	
	private FusekiClient() {}
	
	private static class FusekiClientHolder{
		private static final FusekiClient instance = new FusekiClient();
	}
	
	public static FusekiClient getInstance() {
		return FusekiClientHolder.instance;
	}
	
	/**
	 * 
	 * @param qe
	 * @param sparqlEndPoint
	 * @param query
	 * @return
	 */
	public ResultSet performSelectQuery(QueryExecution qe) {
		return qe.execSelect();
	}

	/**
	 * Returns true or false if the given query string is containd in the triple
	 * store Query should be in the format of ASK {?s ?p ?o}
	 * 
	 * @param query
	 * @param sparqlEndpoint
	 * @return
	 * @throws Exception
	 */
	public boolean performAsk(String query, String sparqlEndpoint) throws Exception {
		QueryExecution qe = QueryExecutionFactory.sparqlService(sparqlEndpoint, query);
		Boolean exists = null;
		try {
			exists = qe.execAsk();
		} catch (Exception e) {
			throw new Exception("Error trying to exceute command: " + e);
		} finally {
			if (qe != null)
				qe.close();
		}
		return exists;
	}
}
