package gov.va.genisis2.ts.utils;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;

@Configuration
@PropertySource("file:${catalina.home}/conf/termservice.properties")
public class TSPropertiesUtil {

	@Value("${ts.ms.create.concept.mapping.uri}")
	private String mappingServiceCreateConceptMappingUri;

	@Value("${ts.ms.get.concept.mapping.concept.uri}")
	private String msGetConceptMappingUriByConceptUri;

	@Value("${ts.sparql.endpoint}")
	private String sparqlEndpoint;

	@Value("${concept.name.sparql.query}")
	private String conceptNameSparqlQuery;

	@Value("${concept.name.query.headvar.name}")
	private String conceptNameQueryHeadvarName;

	@Value("${concept.subtype.sparql.query}")
	private String conceptSubtypeSparqlQuery;

	@Value("${subtype.query.head.var.child.uri}")
	private String subtypeQueryHeadVarChildUri;

	@Value("${subtype.query.head.var.child.name}")
	private String subtypeQueryHeadVarChildName;

	@Value("${concept.predicate.sparql.query}")
	private String conceptPredicateSparqlQuery;

	@Value("${concept.predicate.query.head.var.p}")
	private String conceptPredicateQueryHeadVarP;

	@Value("${concept.predicate.query.head.var.o}")
	private String conceptPredicateQueryHeadVarO;

	@Value("${concept.predicate.query.head.var.n}")
	private String conceptPredicateQueryHeadVarN;

	@Value("${solr.service.endpoint}")
	private String solrServiceEndpoint;
	
	@Value("${solr.search.service.endpoint}")
	private String solrSearchServiceEndpoint;

	@Value("${ts.ms.create.book.marks.uri}")
	private String msCreateBookmarksUri;

	@Value("${ts.ms.get.book.marks.by.username.uri}")
	private String msGetBookmarksByUsernameUri;

	@Value("${ts.ms.get.book.marks.by.label.uri}")
	private String msGetBookmarksByLabelUri;

	@Value("${ts.ms.delete.book.marks.by.id.uri}")
	private String msDeleteBookmarksByIdUri;

	@Value("${ts.ms.create.book.marks.with.label.uri}")
	private String msCreateBookmarksWithLabelUri;

	@Value("${ts.ms.delete.book.marks.by.label.uri}")
	private String msDeleteBookmarksByLabelUri;

	@Value("${ts.ms.get.book.marks.label.by.username.uri}")
	private String msGetBookmarksLabelByUsernameUri;

	@Value("${ts.ms.get.book.mark.by.id}")
	private String bsGetBookmarkById;

	@Value("${ts.sparql.endpoint.update}")
	private String sparqlEndpointUpdate;

	@Value("${ts.mvp.prefix}")
	private String mvpPrefix;

	@Value("${ts.mvp.uri.delimiter}")
	private String mvpUriDelimiter;

	@Value("${ts.mvp.new.concept.regex}")
	private String mvpNewConceptRegex;

	@Value("${conceptmapping.data.elements.sparql.query}")
	private String conceptmappingDataElementsSparqlQuery;

	@Value("${generated.uri.exists.sparql.query}")
	private String generatedUriExistsSparqlQuery;
	
	@Value("${data.element.sparql.query}")
	private String dataElementSparqlQuery;
	
	@Value("${ts.baseline.survey.prefix}")
	private String baselineSurveyPrefix;
	
	@Value("${ts.unknown.ontology}")
	private String unknownOntology;
	
	public String getUnknownOntology() {
		return unknownOntology;
	}
	
	public String getBaselineSurveyPrefix() {
		return baselineSurveyPrefix;
	}
	
	public String getDataElementSparqlQuery() {
		return dataElementSparqlQuery;
	}

	public String getSparqlEndpointUpdate() {
		return sparqlEndpointUpdate;
	}

	public String getBsGetBookmarkById() {
		return bsGetBookmarkById;
	}

	public String getMappingServiceCreateConceptMappingUri() {
		return mappingServiceCreateConceptMappingUri;
	}

	public String getMsGetConceptMappingUriByConceptUri() {
		return msGetConceptMappingUriByConceptUri;
	}

	public String getSparqlEndpoint() {
		return sparqlEndpoint;
	}

	public String getConceptNameSparqlQuery() {
		return conceptNameSparqlQuery;
	}

	public String getConceptNameQueryHeadvarName() {
		return conceptNameQueryHeadvarName;
	}

	public String getConceptSubtypeSparqlQuery() {
		return conceptSubtypeSparqlQuery;
	}

	public String getSubtypeQueryHeadVarChildUri() {
		return subtypeQueryHeadVarChildUri;
	}

	public String getSubtypeQueryHeadVarChildName() {
		return subtypeQueryHeadVarChildName;
	}

	public String getConceptPredicateSparqlQuery() {
		return conceptPredicateSparqlQuery;
	}

	public String getConceptPredicateQueryHeadVarP() {
		return conceptPredicateQueryHeadVarP;
	}

	public String getConceptPredicateQueryHeadVarO() {
		return conceptPredicateQueryHeadVarO;
	}

	public String getConceptPredicateQueryHeadVarN() {
		return conceptPredicateQueryHeadVarN;
	}

	public String getSolrServiceEndpoint() {
		return solrServiceEndpoint;
	}

	public String getSolrSearchServiceEndpoint() {
		return solrSearchServiceEndpoint;
	}

	public String getMsCreateBookmarksUri() {
		return msCreateBookmarksUri;
	}

	public String getMsGetBookmarksByUsernameUri() {
		return msGetBookmarksByUsernameUri;
	}

	public String getMsGetBookmarksByLabelUri() {
		return msGetBookmarksByLabelUri;
	}

	public String getMsDeleteBookmarksByIdUri() {
		return msDeleteBookmarksByIdUri;
	}

	public String getMsCreateBookmarksWithLabelUri() {
		return msCreateBookmarksWithLabelUri;
	}

	public String getMsDeleteBookmarksByLabelUri() {
		return msDeleteBookmarksByLabelUri;
	}

	public String getMsGetBookmarksLabelByUsernameUri() {
		return msGetBookmarksLabelByUsernameUri;
	}

	public String getMvpPrefix() {
		return mvpPrefix;
	}

	public String getMvpUriDelimiter() {
		return mvpUriDelimiter;
	}

	public String getMvpNewConceptRegex() {
		return mvpNewConceptRegex;
	}

	public String getConceptmappingDataElementsSparqlQuery() {
		return conceptmappingDataElementsSparqlQuery;
	}

	public String getGeneratedUriExistsSparqlQuery() {
		return generatedUriExistsSparqlQuery;
	}

	@Bean
	public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
		return new PropertySourcesPlaceholderConfigurer();
	}
}
