/**
 * 
 */
package gov.va.genisis2.ts.utils;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.genisis2.ts.dto.SolrDTO;

/**
 * @author PII
 *
 */
public class TSJsonDeserializer {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		ObjectMapper mapper = new ObjectMapper();

		//String jsonInString = "{\"name\":\"conceptnamestring\",\"uri\":\"sameuriasidentifiedinGETrequest\",\"description\":{\"definition\":\"definitionstring\",\"altDefinitions\":[{\"altDefinition\":\"alternatedefinitionstring\"}],\"synonyms\":[\"synonym1\",\"synonym2\"]},\"relationships\":{\"superClasses\":[{\"name\":\"supertypestring\",\"uri\":\"supertypeuri\"}],\"subClasses\":[{\"name\":\"subtype1string\",\"uri\":\"subtype1uri\"},{\"name\":\"subtype2string\",\"uri\":\"subtyp2euri\"}]}}";
		String jsonInString = "{\"responseHeader\":{\"status\":0,\"QTime\":1,\"params\":{\"q\":\"(Label:*diabetes*)\",\"fl\":\"id,Label,Definition\",\"json\":\"\",\"wt\":\"json\"}},\"response\":{\"numFound\":1023,\"start\":0,\"docs\":[{\"id\":\"http://ncicb.nci.nih.gov/xml/owl/EVS/Thesaurus.owl#C122685\",\"Label\":\"Prediabetes\",\"Definition\":\" A condition in which blood glucose levels are high, but not high enough to be classified as type 2 diabetes.\"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_11895\",\"Label\":\"Nephrogenic diabetes insipidus (588.1)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_16848\",\"Label\":\"Neonatal diabetes mellitus (775.1)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_19506\",\"Label\":\"Family history of diabetes mellitus (V18.0)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_20332\",\"Label\":\"Screening for diabetes mellitus (V77.1)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_7494\",\"Label\":\"Secondary diabetes mellitus (249)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_7495\",\"Label\":\"Secondary diabetes mellitus, without mention of complication (249.0)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_7496\",\"Label\":\"Secondary diabetes mellitus, not stated as uncontrolled, or unspecified (249.00)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_7497\",\"Label\":\"Secondary diabetes mellitus, uncontrolled (249.01)\",\"Definition\":\" \"},{\"id\":\"http://purl.bioontology.org/ontology/HOM-ICD9CM/MM_CLASS_7498\",\"Label\":\"Secondary diabetes mellitus with ketoacidosis (249.1)\",\"Definition\":\" \"}]}}";
		
		// JSON from String to Object
		try {
			//ConceptCardDTO obj = mapper.readValue(jsonInString, ConceptCardDTO.class);
			SolrDTO obj = mapper.readValue(jsonInString, SolrDTO.class);
			System.out.println(obj.getResponse());
			//System.out.println(obj.getName());
			//System.out.println(obj.getDescription().getDefinition());
		} catch (JsonParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (JsonMappingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

}
