package gov.va.genisis2.ts.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.genisis2.ts.common.exception.TSInernalSystemException;
import gov.va.genisis2.ts.common.exception.TSRuntimeException;
import gov.va.genisis2.ts.fuseki.FusekiClient;
import gov.va.genisis2.ts.service.IMappingService;
import gov.va.genisis2.ts.utils.TSPropertiesUtil;

/**
 * @author PII
 *
 */
@Service
public class MappingService implements IMappingService {

	private static final Logger LOGGER = LogManager.getLogger(MappingService.class);

	@Autowired
	private FusekiClient fusekiClient;

	@Resource(name = "selfMappedUriList")
	private List<String> selfMappedUriList;

	@Autowired
	private TSPropertiesUtil propsUtil;

	@Override
	public boolean hasMapping(String conceptUri) {
		boolean hasMapping = false;

		if (null == conceptUri) {
			LOGGER.error("conceptUri is null");
			throw new TSRuntimeException("conceptUri is null");
		} else if (isSelfMappedUri(conceptUri)) {
			return true;
		}

		try {
			// Concept Mapping Data-Elements SPARQL query
			String conceptmappingDataElementsSparqlQuery = String.format(propsUtil.getConceptmappingDataElementsSparqlQuery(), conceptUri);
			hasMapping = fusekiClient.performAsk(conceptmappingDataElementsSparqlQuery, propsUtil.getSparqlEndpoint());
		} catch (Exception e) {
			LOGGER.error("Error in execution Concept Mapping Data-Elements SPARQL query", e);
			throw new TSInernalSystemException("Error in execution Concept Mapping Data-Elements SPARQL query", e);
		}

		return hasMapping;
	}

	private boolean isSelfMappedUri(String conceptUri) {
		return this.selfMappedUriList.stream().filter(s -> s.equalsIgnoreCase(conceptUri)).findFirst().isPresent();
	}
}
