package gov.va.genisis2.ts.service.impl;

import java.util.Map;

import javax.annotation.Resource;

import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ts.utils.TSPropertiesUtil;

@Component
public class ConceptCardHelper {

	@Resource(name = "ontologyNamesMap")
	private Map<String, String> ontologyNamesMap;

	@Autowired
	private TSPropertiesUtil propsUtil;

	public String getOntologyNameForConceptUri(String conceptUri) {
		if (null == conceptUri) {
			return null;
		}

		String ontologyName = ontologyNamesMap.entrySet().stream().filter(e -> conceptUri.toUpperCase().startsWith(e.getKey())).map(Map.Entry::getValue).findFirst().orElse(propsUtil.getUnknownOntology());

		return ontologyName;
	}

	public String getValueOfLiteralOrUri(QuerySolution binding, String headVar) {
		RDFNode literalOrUriNode;
		String valueOfiteralOrUri = null;
		if (null == binding) {
			return null;
		}
		if (binding.contains(headVar) && null != (literalOrUriNode = binding.get(headVar))) {
			org.apache.jena.rdf.model.Resource uriResource;
			if (literalOrUriNode.isLiteral()) {
				Literal literal = literalOrUriNode.asLiteral();
				if (null != literal) {
					valueOfiteralOrUri = literal.toString().trim();
				}
			} else if (literalOrUriNode.isURIResource() && null != (uriResource = literalOrUriNode.asResource())) {
				valueOfiteralOrUri = uriResource.getURI().trim();
			}
		}
		return valueOfiteralOrUri;
	}
}
