package gov.va.genisis2.ts.dto;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class SearchDTO implements Serializable {

	private static final long serialVersionUID = 6486930749651879676L;

	private int totalNumResults;
	private int startingRow;
	private int numRows;
	private List<SearchResultDTO> results;

	public SearchDTO(SolrDTO solrDto) {
		super();
		totalNumResults = solrDto.getResponse().getNumFound();
		startingRow = solrDto.getResponse().getStart();
		numRows = 10;
		List<SolrDocDTO> docs = solrDto.getResponse().getDocs();
		for (int ix = 0; ix < docs.size(); ix++) {
			results.add(new SearchResultDTO(docs.get(ix)));
		}
	}

	/**
	 * @return the totalNumResults
	 */
	public int getTotalNumResults() {
		return totalNumResults;
	}

	/**
	 * @param total
	 *            the total to set
	 */
	public void setTotalNumResults(int total) {
		this.totalNumResults = total;
	}

	/**
	 * @return the startingRow
	 */
	public int getStartingRow() {
		return startingRow;
	}

	/**
	 * @param start
	 *            the start to set
	 */
	public void setStartingRow(int start) {
		this.startingRow = start;
	}

	/**
	 * @return the numRows
	 */
	public int getNumRows() {
		return numRows;
	}

	/**
	 * @param numRows
	 *            the numRows to set
	 */
	public void setNumRows(int numRows) {
		this.numRows = numRows;
	}

	/**
	 * @return the results
	 */
	public List<SearchResultDTO> getResults() {
		return results;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setResults(List<SearchResultDTO> results) {
		this.results = results;
	}
}
