package gov.va.genisis2.swagger;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * SwaggerConfig is used to create a Docket bean and
 * its select() method returns an instance of ApiSelectorBuilder, 
 * which provides a way to control the endpoints exposed by Swagger.
 * 
 * Predicates for selection of RequestHandlers can be configured with 
 * the help of RequestHandlerSelectors and PathSelectors. Using any() for 
 * both will make documentation for your entire API available through Swagger.
 * 
 * @author PII
 *
 */
@Configuration
@EnableSwagger2
@PropertySource({ "classpath:swagger.properties" })
public class SwaggerConfig {
	
	@Value("${genisis.ts.api.title}")
	private String genisisTsApiTitle;

	@Value("${genisis.ts.api.desc}")
	private String genisisTsApiDesc;
	
	@Value("${genisis.ts.api.verion}")
	private String genisisTsApiVersion;
	
	@Value("${genisis.ts.concept.rest.tag.name}")
	private String conceptTagName;
	
	@Value("${genisis.ts.concept.rest.tag.desc}")
	private String conceptTagDesc;
	
	@Value("${genisis.ts.bookmark.rest.tag.name}")
	private String bookmarksTagName;
	
	@Value("${genisis.ts.bookmark.rest.tag.desc}")
	private String bookmarksTagDesc;
	
	@Value("${genisis.ts.mapping.rest.tag.name}")
	private String mappingTagName;
	
	@Value("${genisis.ts.mapping.rest.tag.desc}")
	private String mappingTagDesc;
	
	@Value("${genisis.ts.cli.rest.tag.name}")
	private String cliTagName;
	
	@Value("${genisis.ts.cli.rest.tag.desc}")
	private String cliTagDesc;

	@Bean
	public Docket api() {
		Tag conceptTag = new Tag(conceptTagName, conceptTagDesc);
		Tag bookmarkTag = new Tag(bookmarksTagName, bookmarksTagDesc);
		Tag mappingTag = new Tag(mappingTagName, mappingTagDesc);
		Tag cliTag = new Tag(cliTagName, cliTagDesc);

		return new Docket(DocumentationType.SWAGGER_2)
				.select()
				.apis(RequestHandlerSelectors.any())
				.paths(PathSelectors.any()).build()
				.tags(conceptTag, new Tag[] { bookmarkTag, mappingTag, cliTag })
				.apiInfo(metadata());
	}

	private ApiInfo metadata() {
		return new ApiInfoBuilder()
				.title(genisisTsApiTitle)
				.description(genisisTsApiDesc)
				.version(genisisTsApiVersion)
				.build();
	}
	
	public void setUserTagName(String userTagName) {
		this.conceptTagName = userTagName;
	}
	
	public void setBookmarksTagName(String bookmarksTagName) {
		this.bookmarksTagName = bookmarksTagName;
	}
	
	public void setMappingTagName(String mappingTagName) {
		this.mappingTagName = mappingTagName;
	}
	
	public void setCliTagName(String cliTagName) {
		this.cliTagName = cliTagName;
	}
}
