package gov.va.genisis2.ms.data.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.genisis2.ms.data.model.ConceptMapping;

@Repository
public interface ConceptMappingRepository extends JpaRepository<ConceptMapping, String>{
	
	@Query("select cm " +
			"from ConceptMapping cm " +
			"where cm.conceptUri = :conceptUri")
	public ConceptMapping findConceptMappingForConceptUri(@Param("conceptUri") String conceptUri);
}
