/**
 * 
 */
package gov.va.genisis2.ms.data.model;

import java.io.Serializable;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

/**
 * 
 * @author PII
 *
 */
@Entity
@Table(name = "concept_mapping")
public class ConceptMapping implements Serializable {

	private static final long serialVersionUID = -8294048970234386144L;

	@Id
	@Column(name = "id")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private int id;

	@Column(name = "concept_uri")
	private String conceptUri;

	@Column(name = "term")
	private String term;

	@Column(name = "definition")
	private String definition;

	@Column(name = "algorithm")
	private String algorithm;

	@Column(name = "validation")
	private String validation;

	@OneToMany(fetch = FetchType.EAGER, mappedBy = "conceptMapping", cascade = CascadeType.ALL, orphanRemoval=true)
	@Fetch(FetchMode.SELECT)
	private Set<ConceptMappingDataElement> conceptMappingDataElements;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri
	 *            the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the term
	 */
	public String getTerm() {
		return term;
	}

	/**
	 * @param term
	 *            the term to set
	 */
	public void setTerm(String term) {
		this.term = term;
	}

	/**
	 * @return the definition
	 */
	public String getDefinition() {
		return definition;
	}

	/**
	 * @param definition
	 *            the definition to set
	 */
	public void setDefinition(String definition) {
		this.definition = definition;
	}

	/**
	 * @return the algorithm
	 */
	public String getAlgorithm() {
		return algorithm;
	}

	/**
	 * @param algorithm
	 *            the algorithm to set
	 */
	public void setAlgorithm(String algorithm) {
		this.algorithm = algorithm;
	}

	/**
	 * @return the validation
	 */
	public String getValidation() {
		return validation;
	}

	/**
	 * @param validation
	 *            the validation to set
	 */
	public void setValidation(String validation) {
		this.validation = validation;
	}

	/**
	 * @return the conceptMappingDataElements
	 */
	public Set<ConceptMappingDataElement> getConceptMappingDataElements() {
		return conceptMappingDataElements;
	}

	/**
	 * @param conceptMappingDataElements
	 *            the conceptMappingDataElements to set
	 */
	public void setConceptMappingDataElements(Set<ConceptMappingDataElement> conceptMappingDataElements) {
		this.conceptMappingDataElements = conceptMappingDataElements;
	}
}
