package gov.va.genisis2.ms.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ms.data.dto.DataTypeDTO;
import gov.va.genisis2.ms.data.model.DataType;

@Component
public class DataTypeConverter implements Converter<DataType, DataTypeDTO> {

	@Override
	public DataTypeDTO convert(DataType dataType) {
		DataTypeDTO dataTypeDto = new DataTypeDTO();
		dataTypeDto.setId(dataType.getId());
		dataTypeDto.setName(dataType.getName());

		return dataTypeDto;
	}

	public DataType convert(DataTypeDTO dataTypeDto) {
		DataType dataType = new DataType();
		dataType.setId(dataTypeDto.getId());
		dataType.setName(dataTypeDto.getName());

		return dataType;
	}
}
