package gov.va.genisis2.ms.converter;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ms.data.dto.DataElementSourceDTO;
import gov.va.genisis2.ms.data.model.DataElementSource;

@Component
public class DataElementSourceConverter implements Converter<DataElementSource, DataElementSourceDTO> {

	@Override
	public DataElementSourceDTO convert(DataElementSource dataElementSource) {
		DataElementSourceDTO dataElementSourceDto = new DataElementSourceDTO();
		dataElementSourceDto.setId(dataElementSource.getId());
		dataElementSourceDto.setName(dataElementSource.getName());

		return dataElementSourceDto;
	}

	public DataElementSource convert(DataElementSourceDTO dataElementSourceDto) {
		DataElementSource dataElementSource = new DataElementSource();
		dataElementSource.setId(dataElementSourceDto.getId());
		dataElementSource.setName(dataElementSourceDto.getName());

		return dataElementSource;
	}
}
