package gov.va.genisis2.ms.converter;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.genisis2.ms.data.model.ConceptMapping;
import gov.va.genisis2.ms.data.model.ConceptMappingDataElement;
import gov.va.genisis2.ts.common.dto.ConceptMappingDTO;
import gov.va.genisis2.ts.common.dto.ConceptMappingDataElementDTO;

@Component
public class ConceptMappingConverter implements Converter<ConceptMapping, ConceptMappingDTO> {

	@Autowired
	private ConceptMappingDataElementConverter conceptMappingDataElementConverter;

	@Override
	public ConceptMappingDTO convert(ConceptMapping conceptMapping) {
		ConceptMappingDTO conceptMappingDto = new ConceptMappingDTO();
		conceptMappingDto.setId(conceptMapping.getId());
		conceptMappingDto.setConceptUri(conceptMapping.getConceptUri());
		conceptMappingDto.setTerm(conceptMapping.getTerm());
		conceptMappingDto.setDefinition(conceptMapping.getDefinition());
		conceptMappingDto.setAlgorithm(conceptMapping.getAlgorithm());
		conceptMappingDto.setValidation(conceptMapping.getValidation());

		Set<ConceptMappingDataElement> dataElements = conceptMapping.getConceptMappingDataElements();

		if (null != dataElements && !dataElements.isEmpty()) {
			conceptMappingDto.setConceptMappingDataElements(conceptMappingDataElementConverter.convert(dataElements));
		}

		return conceptMappingDto;
	}

	public ConceptMapping convert(ConceptMappingDTO conceptMappingDto) {
		ConceptMapping conceptMapping = new ConceptMapping();
		conceptMapping.setId(conceptMappingDto.getId());
		conceptMapping.setConceptUri(conceptMappingDto.getConceptUri());
		conceptMapping.setTerm(conceptMappingDto.getTerm());
		conceptMapping.setDefinition(conceptMappingDto.getDefinition());
		conceptMapping.setAlgorithm(conceptMappingDto.getAlgorithm());
		conceptMapping.setValidation(conceptMappingDto.getValidation());
		
		Set<ConceptMappingDataElementDTO> dataElementDtos = conceptMappingDto.getConceptMappingDataElements();

		if (null != dataElementDtos && !dataElementDtos.isEmpty()) {
			conceptMapping.setConceptMappingDataElements(conceptMappingDataElementConverter.convertDataElements(dataElementDtos, conceptMapping));
		}

		return conceptMapping;
	}
	
	public ConceptMapping convert(ConceptMappingDTO conceptMappingDto, ConceptMapping existingConceptMapping) {
		ConceptMapping conceptMapping = new ConceptMapping();
		if (null != existingConceptMapping) {
			conceptMapping.setConceptUri(existingConceptMapping.getConceptUri());
			conceptMapping.setTerm(existingConceptMapping.getTerm());
			conceptMapping.setDefinition(existingConceptMapping.getDefinition());
			conceptMapping.setAlgorithm(existingConceptMapping.getAlgorithm());
			conceptMapping.setValidation(existingConceptMapping.getValidation());
		} else  {
			conceptMapping.setConceptUri(conceptMappingDto.getConceptUri());
			conceptMapping.setTerm(conceptMappingDto.getTerm());
			conceptMapping.setDefinition(conceptMappingDto.getDefinition());
			conceptMapping.setAlgorithm(conceptMappingDto.getAlgorithm());
			conceptMapping.setValidation(conceptMappingDto.getValidation());
		}
		
		Set<ConceptMappingDataElementDTO> dataElementDtos = conceptMappingDto.getConceptMappingDataElements();

		if (null != dataElementDtos && !dataElementDtos.isEmpty()) {
			conceptMapping.setConceptMappingDataElements(conceptMappingDataElementConverter.convertDataElements(dataElementDtos, conceptMapping));
		}

		return conceptMapping;
	}
}
