package gov.va.genisis2.ts.common.exception;

/**
 * Exception class to handle HTTP Status code when duplicate data is arrived
 * 
 * @author Prasad Thummalapalli
 *
 */
public class TSDuplicateDataException extends RuntimeException {

	private static final long serialVersionUID = 5687118813655260314L;

	private final String message;
	private final Throwable throwable;

	/**
	 * @param message
	 *            The error message
	 */
	public TSDuplicateDataException(String message) {
		super(message);
		this.message = message;
		this.throwable = null;
	}

	/**
	 * @param message
	 *            The error message
	 * @param throwable
	 *            The throwable exception
	 */
	public TSDuplicateDataException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}

	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}
