package gov.va.genisis2.ts.common.enums;

/**
 * Holds all the error messages used by the Terminology application
 * 
 * @author Prasad Thummalapalli
 *
 */
public enum ErrorEnum {
	NO_DATA_FOUND_ERROR("No data found for provided search criteria"),
	CONCEPT_MAPPING_NO_DATA_FOUND_ERROR("No mappings found for conceptUri : %s"),
	BOOKMARK_DOESNT_EXIST("Bookmark with id: %s does not exist"),
	BOOKMARK_DUPLICATE_ERROR("Bookmark with %s and %s already exists"),
	CONCEPT_MAPPING_DUPLICATE_ERROR("Concept Mappings already exists for conceptUri : %s"),
	INTERNAL_SYS_ERROR("Internal System error occurred. Please contact your Administrator.");

	private String errorMessage;

	private ErrorEnum() {

	}

	private ErrorEnum(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public String getErrorMessage() {
		return errorMessage;
	}
}
