package gov.va.genisis2.ts.common.dto;

import java.io.Serializable;

import org.apache.commons.lang3.StringUtils;
import org.owasp.esapi.ESAPI;

/**
 * The Class ResponseWrapper.
 *
 * @author Prasad Thummalapalli
 */
public class ResponseWrapper implements Serializable {

	private static final long serialVersionUID = 2190216826395320463L;

	private transient Object response;
	private String message;

	/**
	 * Instantiates a new response wrapper.
	 */
	public ResponseWrapper() {
		this.response = null;
		this.message = StringUtils.EMPTY;
	}

	public ResponseWrapper(Object response) {
		this.response = response;
		this.message = StringUtils.EMPTY;
	}

	public ResponseWrapper(String message) {
		this.response = null;
		this.message = ESAPI.encoder().encodeForHTML(message);
	}

	/**
	 * Gets the response.
	 *
	 * @return the response
	 */
	public Object getResponse() {
		return response;
	}

	/**
	 * Sets the response.
	 *
	 * @param response
	 *            the new response
	 */
	public void setResponse(Object response) {
		this.response = response;
	}

	/**
	 * Gets the message.
	 *
	 * @return the message
	 */
	public String getMessage() {
		return message;
	}

	/**
	 * Sets the message.
	 *
	 * @param message
	 *            the new message
	 */
	public void setMessage(String message) {
		this.message = message;
	}
}
