package gov.va.genisis2.ts.common.dto;

import java.io.Serializable;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import gov.va.genisis2.ts.objectmapper.EscapeHtmlSerializer;

/**
 * Data Transfer Object (DTO) to transfer mapping details of concepts and
 * data-elements
 * 
 * @author Prasad Thummalapalli
 *
 */
@JsonIgnoreProperties({ "id", "conceptUri", "conceptMappingId" })
public class ConceptMappingDataElementDTO implements Serializable {

	private static final long serialVersionUID = 507376600675998770L;

	private int id;
//	@JsonSerialize(using = EscapeHtmlSerializer.class)
	private String conceptUri;
	private int dataElementId;
	private int conceptMappingId;

	/**
	 * @return the id
	 */
	public int getId() {
		return id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(int id) {
		this.id = id;
	}

	/**
	 * @return the conceptUri
	 */
	public String getConceptUri() {
		return conceptUri;
	}

	/**
	 * @param conceptUri
	 *            the conceptUri to set
	 */
	public void setConceptUri(String conceptUri) {
		this.conceptUri = conceptUri;
	}

	/**
	 * @return the dataElementId
	 */
	public int getDataElementId() {
		return dataElementId;
	}

	/**
	 * @param dataElementId
	 *            the dataElementId to set
	 */
	public void setDataElementId(int dataElementId) {
		this.dataElementId = dataElementId;
	}

	/**
	 * @return the conceptMappingId
	 */
	public int getConceptMappingId() {
		return conceptMappingId;
	}

	/**
	 * @param conceptMappingId
	 *            the conceptMappingId to set
	 */
	public void setConceptMappingId(int conceptMappingId) {
		this.conceptMappingId = conceptMappingId;
	}
}
