package gov.va.genisis2.bs.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import gov.va.genisis2.bs.data.model.Label;

/**
 * JPA Repository to handle Label Transactions
 * @author PII
 */
public interface LabelRepository extends JpaRepository<Label, Integer> {

	@Query("SELECT l FROM Label l WHERE l.username = :username ORDER BY l.id DESC")
	public List<Label> getAllLabelsGivenUsername(@Param("username") String username );
}
