package gov.va.genisis2.bs.data.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import gov.va.genisis2.bs.data.model.Bookmark;

/**
 * JPA Repository to handle Bookmark Transactions
 * @author PII
 */
@Repository
public interface BookmarkRepository extends JpaRepository<Bookmark, Integer> {
	
	@Query("SELECT b FROM Bookmark b WHERE b.username = :username ORDER BY b.id DESC")
	public List<Bookmark> getAllBookmarksAndLabelsGivenUsername(@Param("username") String username );
	
	@Query( "SELECT b FROM Bookmark b JOIN b.labels c where CONVERT(DNS  AR, c.name) = :label ORDER BY c.id DESC")
	public List<Bookmark> getAllBookmakrsGivenLabel( @Param("label") String label );
}
